/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.security;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureCsrfCheckServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(ConfigureCsrfCheckServlet.class);

    @Inject
    public ConfigureCsrfCheckServlet(RequireAdminServletDependencyBucket bucket, @ComponentImport PluginAccessor pluginAccessor) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "csrfcheck");
        model.put("isCsrfOriginCheckEnabled", this.kerbConfManager.isCsrfOriginCheckEnabled());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("displayName", this.applicationProperties.getDisplayName());
        StringBuilder sb = new StringBuilder();
        for (String path : this.kerbConfManager.getPreemptiveAuthExcludedPaths()) {
            sb.append(path).append("\n");
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/enableCsrfOriginCheck.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        boolean isCsrfOriginCheckEnabled = StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("isCsrfOriginCheckEnabled"));
        this.kerbConfManager.setCsrfOriginCheckEnabled(isCsrfOriginCheckEnabled);
        resp.sendRedirect("csrfcheck");
    }
}

