/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import java.io.IOException;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpCertificatesServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(IdpCertificatesServlet.class);
    private final IdpConfManager idpConfManager;

    @Inject
    public IdpCertificatesServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = IdpConfManager.IdpServletUtil.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "certificates");
        model.put("idp", configuration);
        configuration.ifSaml(samlConf -> {
            List<byte[]> signingCerts = samlConf.getSigningCerts();
            CertTool certTool = new CertTool();
            List validationCerts = io.vavr.collection.List.ofAll(signingCerts).map(bytes -> {
                X509Certificate cert = CertTool.parse(bytes);
                JSONObject certJson = new JSONObject();
                certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
                certJson.put("notBefore", (Object)cert.getNotBefore().toString());
                certJson.put("notAfter", (Object)cert.getNotAfter().toString());
                certJson.put("sigAlgName", (Object)cert.getSigAlgName());
                certJson.put("keySize", (Object)String.valueOf(certTool.getKeySize(cert)));
                certJson.put("fingerPrint", (Object)CertTool.fingerPrint(bytes));
                return certJson;
            }).asJava();
            model.put("validationCerts", validationCerts);
        });
        this.getTemplateRenderer().render("templates/saml/saml-idp-certificates.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws IOException {
        MultipartHttpRequest req = this.getMultipartRequest(request, 5000000L);
        String id = IdpConfManager.IdpServletUtil.getId((HttpServletRequest)req);
        String action = req.getParameter("action");
        if ("addIdpCertificate".equals(action)) {
            Map<String, Object> model = this.newModel((HttpServletRequest)req);
            this.addIdpCert(req, id, model);
            this.renderPage((HttpServletRequest)req, resp, model);
            return;
        }
        if ("deleteIdpCertificate".equals(action)) {
            String deleteFingerprint = req.getParameter("deleteFingerprint");
            this.idpConfManager.deleteIdpCert(id, deleteFingerprint);
            Map<String, Object> model = this.newModel((HttpServletRequest)req);
            this.renderPage((HttpServletRequest)req, resp, model);
            return;
        }
        resp.sendRedirect("certificates");
    }

    private void addIdpCert(MultipartHttpRequest req, String id, Map<String, Object> model) {
        String pastedSigningCert;
        String certChoice = req.getParameter("certChoice");
        if ("upload".equals(certChoice)) {
            byte[] signingCertFile = req.getFile("signingCertFile");
            if (signingCertFile != null) {
                try {
                    this.idpConfManager.parseCert(signingCertFile);
                    this.idpConfManager.addIdpCert(id, signingCertFile);
                }
                catch (Exception e) {
                    log.debug("Could not parse uploaded certificate", (Throwable)e);
                    model.put("certError", Boolean.TRUE);
                }
            }
        } else if ("paste".equals(certChoice) && (pastedSigningCert = req.getParameter("pastedSigningCert")) != null && !pastedSigningCert.trim().isEmpty()) {
            try {
                byte[] signingCert = Base64.decodeBase64((String)CertTool.unwrapCert(pastedSigningCert));
                this.idpConfManager.parseCert(signingCert);
                this.idpConfManager.addIdpCert(id, signingCert);
            }
            catch (Exception e) {
                log.debug("Could not parse pasted certificate", (Throwable)e);
                model.put("certError", Boolean.TRUE);
            }
        }
    }
}

