/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.apitokens.latest.user;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.control.Option;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteToken {
    private static final Logger log = LoggerFactory.getLogger(DeleteToken.class);

    public static Response run(String id, UserProfile userProfile, ApiTokenService apiTokenService, UserManager userManager) {
        Option maybeApiTokenObject = Option.of((Object)apiTokenService.findTokenById(id));
        if (maybeApiTokenObject.isDefined()) {
            ApiTokenV570 apiTokenObject = (ApiTokenV570)maybeApiTokenObject.get();
            if (!StringUtils.equals((CharSequence)apiTokenObject.getUsername(), (CharSequence)userProfile.getUsername()) && !userManager.isSystemAdmin(userProfile.getUserKey())) {
                String forbiddenMessage = "Forbidden: not allowed to delete API token";
                log.error("Forbidden: not allowed to delete API token");
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            String description = apiTokenObject.getTokenName();
            boolean deleted = (Boolean)maybeApiTokenObject.map(apiTokenService::delete).getOrElse((Object)false);
            if (deleted) {
                return Response.ok((Object)("Successfully deleted API token " + description + " with ID " + apiTokenObject.getID())).build();
            }
            String failedDeleteErrorMessage = "Failed to delete API token " + description + " with id " + apiTokenObject.getID();
            log.warn(failedDeleteErrorMessage);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)failedDeleteErrorMessage).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

