/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc.evaluation;

import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.UserProperty;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcResponseEvaluationResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OidcResponseEvaluator
extends ResponseEvaluator {
    private final Logger log = LoggerFactory.getLogger(OidcResponseEvaluator.class);

    @Inject
    public OidcResponseEvaluator(HostAppFactory hostAppFactory, UserLookupService userLookupService) {
        super(userLookupService, hostAppFactory.getInstance());
    }

    public static List<AttributeInfo> getAttributeInfos(JSONObject profileJson, String customUsernameAttributeName) {
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        for (String key : profileJson.keySet()) {
            if (key.equals("id_token")) continue;
            try {
                attributeInfos.add(new AttributeInfo(key, profileJson.get(key).toString(), IdpConfiguration.UsernameAttribute.valueOf(key.toUpperCase())));
            }
            catch (IllegalArgumentException e) {
                if (customUsernameAttributeName != null && customUsernameAttributeName.equals(key)) {
                    attributeInfos.add(new AttributeInfo(key, profileJson.get(key).toString(), IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME));
                    continue;
                }
                attributeInfos.add(new AttributeInfo(key, profileJson.get(key).toString()));
            }
        }
        return attributeInfos;
    }

    public OidcResponseEvaluationResult evaluate(OidcIdpConfiguration idpConfiguration, JSONObject profile, IdpConfiguration.UsernameAttribute usernameAttribute, String nameAttribute, String givenNameAttribute, String surnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String emailAttribute, String customUsernameAttributeName, boolean addDefaultGroups) {
        List<AttributeInfo> attributeInfos = OidcResponseEvaluator.getAttributeInfos(profile, customUsernameAttributeName);
        OidcResponseEvaluationResult result = new OidcResponseEvaluationResult(idpConfiguration, attributeInfos, usernameAttribute, nameAttributeMapping, customUsernameAttributeName);
        String nameAttributes = "";
        if (IdpConfManager.NAME_ATTRIBUTE_MAPPING.FIRST_AND_LAST_NAME.equals((Object)nameAttributeMapping)) {
            if (givenNameAttribute != null && surnameAttribute != null) {
                nameAttributes = givenNameAttribute + ", " + surnameAttribute;
            } else if (surnameAttribute != null) {
                nameAttributes = surnameAttribute;
            } else if (givenNameAttribute != null) {
                nameAttributes = givenNameAttribute;
            }
        } else {
            nameAttributes = nameAttribute;
        }
        Either<String, UserRecipe> maybeUserRecipe = this.findUserRecipe(profile, result, nameAttributes, emailAttribute);
        if (maybeUserRecipe.isLeft()) {
            return OidcResponseEvaluationResult.Builder.of(result).setErrorMessage((String)maybeUserRecipe.getLeft()).build();
        }
        return (OidcResponseEvaluationResult)this.evaluateResult(idpConfiguration, result, (UserRecipe)maybeUserRecipe.get(), addDefaultGroups).mapTry(OidcResponseEvaluationResult.class::cast).onFailure(t -> this.log.warn(ErrorUtils.createErrorMessage("KSSO-YU1EL3NDA9", "Failed to complete response evaluation"), t)).getOrElse((Object)OidcResponseEvaluationResult.Builder.of(result).setErrorMessage(ErrorUtils.createErrorMessage("KSSO-YU1EL3NDA9", "Failed to complete response evaluation")).build());
    }

    private Either<String, UserRecipe> findUserRecipe(JSONObject profileJson, OidcResponseEvaluationResult result, String nameAttribute, String emailAttribute) {
        if (Option.of((Object)result).isEmpty()) {
            return Either.left((Object)ErrorUtils.createErrorMessage("KSSO-WO2FBW6GQS", "Could not find response evaluation result."));
        }
        if (Option.of((Object)profileJson).isEmpty()) {
            return Either.left((Object)ErrorUtils.createErrorMessage("KSSO-Y86V7LN2MP", "Invalid JSON while searching for user recipe."));
        }
        Option maybeConfiguredAttributeInfo = Option.of((Object)result.getConfiguredUsernameAttributeInfo());
        String searchedUsername = result.getSearchedUsername();
        if (maybeConfiguredAttributeInfo.isEmpty()) {
            return Either.left((Object)ErrorUtils.createErrorMessage("KSSO-DI9HFISO0R", "Failed to find configured username attribute."));
        }
        UserProperty username = (UserProperty)maybeConfiguredAttributeInfo.map(attributeInfo -> new UserProperty(attributeInfo.getId(), searchedUsername)).get();
        UserProperty name = null;
        if (nameAttribute != null) {
            String nameBuild = OidcResponseEvaluator.mergeNameAttributes(profileJson, nameAttribute);
            name = new UserProperty(nameAttribute, nameBuild);
        }
        UserProperty email = null;
        if (StringUtils.isNotBlank((CharSequence)emailAttribute) && profileJson.has(emailAttribute) && profileJson.get(emailAttribute) != null) {
            email = new UserProperty(emailAttribute, OidcResponseEvaluator.getFirstInJSONArrayIfKeyContainsEmail(profileJson, emailAttribute));
        }
        return Either.right((Object)new UserRecipe(username, name, email));
    }

    static String mergeNameAttributes(JSONObject profileJson, String nameAttribute) {
        Object[] nameAttributes = StringUtils.split((String)nameAttribute, (String)",");
        String nameBuild = (String)io.vavr.collection.List.of((Object[])nameAttributes).filter(StringUtils::isNotBlank).map(StringUtils::trim).filter(attribute -> profileJson.has(attribute) && profileJson.get(attribute) != null).filter(attribute -> profileJson.get(attribute) instanceof String).map(attribute -> profileJson.get(attribute).toString()).filter(StringUtils::isNotBlank).intersperse((Object)" ").foldLeft((Object)"", String::concat);
        return nameBuild;
    }

    private static String getFirstInJSONArrayIfKeyContainsEmail(JSONObject profileJson, String key) {
        Object value = profileJson.get(key);
        if (StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)"email") && value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            value = array.get(0);
        }
        return value.toString();
    }

    public Set<String> findOidcGroups(JSONObject profileJson, Set<String> groupsParameters) {
        HashSet<String> result = new HashSet<String>();
        for (String param : groupsParameters) {
            try {
                List groups = profileJson.getJSONArray(param).toList();
                for (Object group : groups) {
                    result.add(group.toString());
                }
            }
            catch (JSONException jSONException) {
            }
        }
        return result;
    }
}

