/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc.evaluation;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class OidcResponseEvaluationResult
extends FederatedIdentityResponseEvaluationResult {
    private final String errorMessage;
    private final ResponseEvaluationCode code;

    public OidcResponseEvaluationResult(OidcIdpConfiguration idpConfiguration, List<AttributeInfo> attributeInfos, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customUsernameAttributeName) {
        super(idpConfiguration, attributeInfos, usernameAttribute, nameAttributeMapping, customUsernameAttributeName);
        this.errorMessage = "";
        this.code = ResponseEvaluationCode.UNKNOWN;
    }

    public OidcResponseEvaluationResult(OidcIdpConfiguration idpConfiguration, List<AttributeInfo> attributeInfos, IdpConfiguration.UsernameAttribute usernameAttribute, String customUsernameAttributeName, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, ResponseEvaluationCode code, String errorMessage) {
        super(idpConfiguration, attributeInfos, usernameAttribute, nameAttributeMapping, customUsernameAttributeName);
        this.code = code;
        this.errorMessage = errorMessage;
    }

    public boolean isFailed() {
        return StringUtils.isNotBlank((CharSequence)this.errorMessage);
    }

    public boolean isSuccess() {
        return StringUtils.isBlank((CharSequence)this.errorMessage);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public ResponseEvaluationCode getCode() {
        if (this.code == ResponseEvaluationCode.UNKNOWN) {
            return super.getCode();
        }
        return this.code;
    }

    public static class Builder {
        private OidcIdpConfiguration idpConfiguration;
        private List<AttributeInfo> attributeInfos;
        private IdpConfiguration.UsernameAttribute usernameAttribute;
        private IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping;
        private String customUsernameAttributeName;
        private ResponseEvaluationCode code;
        private String errorMessage;

        public OidcResponseEvaluationResult build() {
            return new OidcResponseEvaluationResult(this.idpConfiguration, this.attributeInfos, this.usernameAttribute, this.customUsernameAttributeName, this.nameAttributeMapping, this.code, this.errorMessage);
        }

        private Builder(OidcIdpConfiguration oidcIdpConfiguration, List<AttributeInfo> attributeInfos, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customUsernameAttributeName) {
            this.idpConfiguration = oidcIdpConfiguration;
            this.attributeInfos = attributeInfos;
            this.usernameAttribute = usernameAttribute;
            this.nameAttributeMapping = nameAttributeMapping;
            this.customUsernameAttributeName = customUsernameAttributeName;
            this.errorMessage = "";
            this.code = ResponseEvaluationCode.UNKNOWN;
        }

        private Builder(OidcIdpConfiguration oidcIdpConfiguration, List<AttributeInfo> attributeInfos, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customUsernameAttributeName, String errorMessage) {
            this.idpConfiguration = oidcIdpConfiguration;
            this.attributeInfos = attributeInfos;
            this.usernameAttribute = usernameAttribute;
            this.nameAttributeMapping = nameAttributeMapping;
            this.customUsernameAttributeName = customUsernameAttributeName;
            this.errorMessage = errorMessage;
            this.code = ResponseEvaluationCode.UNKNOWN;
        }

        public static Builder of(OidcResponseEvaluationResult result) {
            return new Builder((OidcIdpConfiguration)result.getIdpConfiguration(), result.getAttributeInfos(), result.getUsernameAttribute(), result.getNameAttributeMapping(), result.getCustomUsernameAttributeName());
        }

        public IdpConfiguration getIdpConfiguration() {
            return this.idpConfiguration;
        }

        public Builder setIdpConfiguration(OidcIdpConfiguration idpConfiguration) {
            this.idpConfiguration = idpConfiguration;
            return this;
        }

        public List<AttributeInfo> getAttributeInfos() {
            return this.attributeInfos;
        }

        public Builder setAttributeInfos(List<AttributeInfo> attributeInfos) {
            this.attributeInfos = attributeInfos;
            return this;
        }

        public IdpConfiguration.UsernameAttribute getUsernameAttribute() {
            return this.usernameAttribute;
        }

        public Builder setUsernameAttribute(IdpConfiguration.UsernameAttribute usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public String getCustomUsernameAttributeName() {
            return this.customUsernameAttributeName;
        }

        public Builder setNameAttributeMapping(IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping) {
            this.nameAttributeMapping = nameAttributeMapping;
            return this;
        }

        public Builder setCustomUsernameAttributeName(String customUsernameAttributeName) {
            this.customUsernameAttributeName = customUsernameAttributeName;
            return this;
        }

        public ResponseEvaluationCode getCode() {
            return this.code;
        }

        public Builder setCode(ResponseEvaluationCode code) {
            this.code = code;
            return this;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }
    }
}

