/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.gsuite;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorURIBuilder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.api.MembershipHandler;
import org.kantega.atlaskerb.connector.api.UserHandler;
import org.kantega.atlaskerb.connector.gsuite.GSuiteHttpClient;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSuiteApi
implements ConnectorAPI {
    private static final Logger log = LoggerFactory.getLogger(GSuiteApi.class);
    private final String domainName;
    private final String customerId;
    private final String apiBaseUrl = System.getProperty("connector.gsuite.api.url", "https://www.googleapis.com");
    private final GSuiteHttpClient client;
    private final int maxResults = Integer.parseInt(System.getProperty("connector.gsuite.maxResults", "-1"));

    public GSuiteApi(String domainName, String customerId, String serviceAccountId, String adminAccountAddress, String privateKey) {
        this.domainName = domainName;
        this.customerId = customerId;
        this.client = new GSuiteHttpClient(this.apiBaseUrl, adminAccountAddress, serviceAccountId, privateKey);
    }

    @Override
    public void findAllUsers(UserHandler userHandler) throws InterruptedException {
        String nextPageToken = null;
        do {
            String u;
            ConnectorHttpClient.Response response;
            JSONObject responseJson;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllUsers aborting");
            }
            ConnectorURIBuilder builder = this.requestUriBuilder("/admin/directory/v1/users");
            ConnectorURIBuilder connectorURIBuilder = builder = StringUtils.isNotBlank((CharSequence)this.customerId) ? builder.queryParam("customer", this.customerId) : builder.queryParam("domain", this.domainName);
            if (nextPageToken != null) {
                builder.queryParam("pageToken", nextPageToken);
            }
            nextPageToken = !(responseJson = (response = this.client.httpGet(u = builder.toString())).getAsJSONObject()).isNull("nextPageToken") ? responseJson.getString("nextPageToken") : null;
            JSONArray usersJson = (JSONArray)responseJson.get("users");
            for (int i = 0; i < usersJson.length(); ++i) {
                UserItem user = this.toUserItem((JSONObject)usersJson.get(i));
                userHandler.handleUser(user);
            }
        } while (nextPageToken != null);
    }

    @Override
    public void findAllGroups(GroupHandler groupHandler) throws InterruptedException {
        String nextPageToken = null;
        do {
            String u;
            ConnectorHttpClient.Response response;
            JSONObject responseJson;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllGroups aborting");
            }
            ConnectorURIBuilder builder = this.requestUriBuilder("/admin/directory/v1/groups").queryParam("domain", this.domainName);
            if (nextPageToken != null) {
                builder.queryParam("pageToken", nextPageToken);
            }
            nextPageToken = !(responseJson = (response = this.client.httpGet(u = builder.toString())).getAsJSONObject()).isNull("nextPageToken") ? responseJson.getString("nextPageToken") : null;
            JSONArray groupsJson = (JSONArray)responseJson.get("groups");
            for (int i = 0; i < groupsJson.length(); ++i) {
                JSONObject groupJson = (JSONObject)groupsJson.get(i);
                GroupItem group = new GroupItem();
                group.setName(groupJson.getString("name"));
                group.setId(groupJson.getString("id"));
                group.setActive(true);
                groupHandler.handleGroup(group);
            }
        } while (nextPageToken != null);
    }

    @Override
    public void findAllMemberships(Set<UserItem> includedUsers, Set<GroupItem> includedGroups, MembershipHandler membershipHandler) throws InterruptedException {
        HashMap groupNameById = new HashMap();
        includedGroups.forEach(g -> groupNameById.put(g.getId(), g.getName()));
        HashMap userNameById = new HashMap();
        includedUsers.forEach(u -> userNameById.put(u.getKey(), u.getName()));
        for (String groupId : groupNameById.keySet()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllMemberships aborting");
            }
            String groupName = (String)groupNameById.get(groupId);
            MembershipItem group = new MembershipItem();
            group.setName(groupName);
            String nextPageToken = null;
            do {
                String u2;
                ConnectorHttpClient.Response response;
                JSONObject responseJson;
                ConnectorURIBuilder builder = this.requestUriBuilder("/admin/directory/v1/groups/" + groupId + "/members");
                if (nextPageToken != null) {
                    builder.queryParam("pageToken", nextPageToken);
                }
                nextPageToken = !(responseJson = (response = this.client.httpGet(u2 = builder.toString())).getAsJSONObject()).isNull("nextPageToken") ? responseJson.getString("nextPageToken") : null;
                if (responseJson.isNull("members")) continue;
                JSONArray membersJson = (JSONArray)responseJson.get("members");
                for (int i = 0; i < membersJson.length(); ++i) {
                    JSONObject memberJson = (JSONObject)membersJson.get(i);
                    String type = memberJson.getString("type");
                    String userId = memberJson.getString("id");
                    String userName = (String)userNameById.get(userId);
                    if (userName != null) {
                        UserMember member = new UserMember();
                        member.setName(userName);
                        group.getUserCollection().getUsers().add(member);
                        continue;
                    }
                    if (!"USER".equals(type)) continue;
                    String email = memberJson.optString("email");
                    log.debug("User {} ({}) is member of {} but wasn't found in filtered user list; skipping.", new Object[]{userId, email, groupName});
                }
            } while (nextPageToken != null);
            membershipHandler.handleMembership(group);
        }
    }

    private UserItem toUserItem(JSONObject jsonUser) {
        try {
            JSONObject nameJson = (JSONObject)jsonUser.get("name");
            UserItem user = new UserItem();
            user.setDisplayName(nameJson.getString("fullName"));
            user.setFirstName(nameJson.getString("givenName"));
            user.setLastName(nameJson.getString("familyName"));
            user.setKey(jsonUser.getString("id"));
            user.setUserType(UserItem.UserType.MEMBER);
            user.setActive(!jsonUser.getBoolean("suspended"));
            String primaryEmail = jsonUser.getString("primaryEmail");
            user.setEmail(primaryEmail);
            user.setName(primaryEmail);
            return user;
        }
        catch (JSONException e) {
            log.warn(String.format("Retrieved a JSON object from Gsuite without a name. Unable to convert it to a user object: %s", jsonUser.toString(0)));
            return null;
        }
    }

    private ConnectorURIBuilder requestUriBuilder(String path) {
        ConnectorURIBuilder builder = ConnectorURIBuilder.builder(this.apiBaseUrl + path);
        if (this.maxResults > 0) {
            builder.queryParam("maxResults", String.valueOf(this.maxResults));
        }
        return builder;
    }
}

