/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;

public class ApiTokenAdminServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;

    @Inject
    public ApiTokenAdminServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-admin.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        HashMap protoModel = HashMap.empty();
        if (!protoModel.isEmpty()) {
            return;
        }
        if ("delete".equals(req.getParameter("operation"))) {
            Option.of((Object)req.getParameter("tokenId")).map(this.apiTokenService::findTokenById).filter(Objects::nonNull).forEach(this.apiTokenService::delete);
            this.buildModelAndRenderTemplate(req, resp, protoModel.toJavaMap());
        } else {
            Option<String> maybeToken = this.apiTokenService.createAndPersistToken(req);
            if (maybeToken.isDefined()) {
                this.buildModelAndRenderTemplate(req, resp, protoModel.merge((Map)protoModel.put((Object)"newApiToken", maybeToken.get())).toJavaMap());
                return;
            }
            this.buildModelAndRenderTemplate(req, resp, protoModel.toJavaMap());
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, java.util.Map<String, Object> protoModel) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-admin.vm", model, (Writer)resp.getWriter());
    }

    private java.util.Map<String, Object> buildModel(HttpServletRequest req) {
        java.util.Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("durationOptions", ApiTokenUtil.DatePair.getDurationOptions());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("tokens", this.getTokensRepresentation());
        return model;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation() {
        return io.vavr.collection.List.ofAll(this.apiTokenService.findAllTokens()).map(t -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenV570)t, this.userManager, this.apiTokenService)).asJava();
    }
}

