/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.regextranformation.RegexTransformationResult;

public class ConfigureUserMappingAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;

    @Inject
    public ConfigureUserMappingAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
    }

    private boolean isSettingsDirty(String additionalUserSuffix, String regexLookup, String regexReplacement) {
        return !StringUtils.equals((CharSequence)additionalUserSuffix, (CharSequence)this.kerbConfManager.getAdditionalUserSuffix()) || !StringUtils.equals((CharSequence)regexLookup, (CharSequence)this.kerbConfManager.getRegexLookup()) || !StringUtils.equals((CharSequence)regexReplacement, (CharSequence)this.kerbConfManager.getRegexReplacement());
    }

    private void generateLookupDirectories(Map<String, Object> model, String kerberosPrincipal) {
        LinkedHashMap<String, Set<String>> lookupMap = new LinkedHashMap<String, Set<String>>();
        model.put("lookupMap", lookupMap);
        List<Directory> activeUserDirectories = this.userLookupService.getActiveUserDirectories();
        for (Directory directory : activeUserDirectories) {
            Set<String> lookupNames = this.userLookupService.determineLookupNames(kerberosPrincipal, directory, this.kerbConfManager.getRegexLookup(), this.kerbConfManager.getRegexReplacement(), this.kerbConfManager.getAdditionalUserSuffix());
            lookupMap.put(directory.getName(), lookupNames);
        }
    }

    private void renderUserMappings(HttpServletResponse resp, String kerberosPrincipal, Map<String, Object> model) throws IOException {
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("userNameAttributeLookupEnabled", this.kerbConfManager.isUserNameAttributeLookupEnabled());
        model.put("kerberosPrincipal", kerberosPrincipal);
        if (kerberosPrincipal == null || !kerberosPrincipal.contains("@")) {
            model.put("invalidSpn", true);
        } else {
            this.generateLookupDirectories(model, kerberosPrincipal);
        }
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/usermapping.vm", model, (Writer)resp.getWriter());
    }

    private void addRegexToModel(Map<String, Object> model, String kerberosPrincipal, String regexLookup, String regexReplacement) {
        RegexTransformationResult regexResult = UserMappingUtils.regexTransformPairToResult(kerberosPrincipal, regexLookup, regexReplacement);
        String transformedUsername = regexResult.getResult();
        String regexErrorMessage = regexResult.getErrorMessage();
        model.put("regexLookup", regexLookup);
        model.put("regexReplacement", regexReplacement);
        model.put("transformedUsername", transformedUsername);
        model.put("regexErrorMessage", regexErrorMessage);
        model.put("additionalUserSuffix", null);
    }

    private boolean updateKerbconfManager(String kerberosPrincipal, String regexLookup, String regexReplacement, boolean regexEnabled, String additionalUserSuffix, String usernameAttributeLookup) {
        if (regexEnabled && regexLookup != null && regexReplacement != null) {
            RegexTransformationResult result = UserMappingUtils.regexTransformPairToResult(kerberosPrincipal, regexLookup = StringUtils.trimToNull((String)regexLookup), regexReplacement = StringUtils.trimToNull((String)regexReplacement));
            if (!StringUtils.isEmpty((CharSequence)result.getErrorMessage())) {
                return false;
            }
            this.kerbConfManager.setRegexLookup(regexLookup);
            this.kerbConfManager.setRegexReplacement(regexReplacement);
            this.kerbConfManager.setAdditionalUserSuffix(null);
        } else if (additionalUserSuffix != null) {
            additionalUserSuffix = StringUtils.trimToNull((String)additionalUserSuffix);
            this.kerbConfManager.setAdditionalUserSuffix(additionalUserSuffix);
            this.kerbConfManager.setRegexLookup(null);
            this.kerbConfManager.setRegexReplacement(null);
        }
        if (usernameAttributeLookup != null) {
            this.kerbConfManager.setUserNameAttributeLookupEnabled(!this.kerbConfManager.isUserNameAttributeLookupEnabled());
        }
        this.kerbConfManager.setRegexLookupEnabled(regexEnabled);
        return true;
    }

    private String generateKerberosPrincipal(String remoteUsername) {
        return (String)Option.of((Object)remoteUsername).map(username -> {
            Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
            String principalSuffix = "@" + keytab.realms().iterator().next();
            if (username.contains("@")) {
                return username.substring(0, username.indexOf("@")) + principalSuffix;
            }
            return username + principalSuffix;
        }).getOrNull();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String remoteUsername = (String)Option.of((Object)this.userManager.getRemoteUser(req)).map(UserProfile::getUsername).getOrNull();
        String kerberosPrincipal = this.generateKerberosPrincipal(remoteUsername);
        Map<String, Object> model = this.newModel(req);
        this.addRegexToModel(model, kerberosPrincipal, this.kerbConfManager.getRegexLookup(), this.kerbConfManager.getRegexReplacement());
        model.put("additionalUserSuffix", this.kerbConfManager.getAdditionalUserSuffix());
        model.put("regexEnabled", this.kerbConfManager.isRegexLookupEnabled());
        this.renderUserMappings(resp, kerberosPrincipal, model);
    }

    private void addAdditionalUserSuffixToModel(Map<String, Object> model, String additionalUserSuffix) {
        model.put("additionalUserSuffix", additionalUserSuffix);
        model.put("regexLookup", null);
        model.put("regexReplacement", null);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String additionalUserSuffix = req.getParameter("additionalUserSuffix");
        String regexLookup = req.getParameter("regexLookup");
        String regexReplacement = req.getParameter("regexReplacement");
        boolean regexEnabled = req.getParameter("radiobuttons").equals("regex");
        String userNameAttributeLookup = req.getParameter("userNameAttributeLookup");
        if (req.getParameter("testUserNameAttributeLookup") != null) {
            String kerberosPrincipal = req.getParameter("kerberosPrincipal").trim();
            if (regexEnabled && regexLookup != null && regexReplacement != null) {
                regexLookup = StringUtils.trimToNull((String)regexLookup);
                regexReplacement = StringUtils.trimToNull((String)regexReplacement);
                this.addRegexToModel(model, kerberosPrincipal, regexLookup, regexReplacement);
            } else if (additionalUserSuffix != null) {
                additionalUserSuffix = StringUtils.trimToNull((String)additionalUserSuffix);
                this.addAdditionalUserSuffixToModel(model, additionalUserSuffix);
            }
            model.put("regexEnabled", regexEnabled);
            model.put("dirtySettings", this.isSettingsDirty(additionalUserSuffix, regexLookup, regexReplacement));
            this.renderUserMappings(resp, kerberosPrincipal, model);
            return;
        }
        String remoteUsername = (String)Option.of((Object)this.userManager.getRemoteUser(req)).map(UserProfile::getUsername).getOrNull();
        String kerberosPrincipal = this.generateKerberosPrincipal(remoteUsername);
        boolean success = this.updateKerbconfManager(kerberosPrincipal, regexLookup, regexReplacement, regexEnabled, additionalUserSuffix, userNameAttributeLookup);
        if (success) {
            this.addRegexToModel(model, kerberosPrincipal, this.kerbConfManager.getRegexLookup(), this.kerbConfManager.getRegexReplacement());
            model.put("additionalUserSuffix", this.kerbConfManager.getAdditionalUserSuffix());
            model.put("regexEnabled", this.kerbConfManager.isRegexLookupEnabled());
        } else {
            if (regexEnabled) {
                this.addRegexToModel(model, kerberosPrincipal, StringUtils.trimToNull((String)regexLookup), StringUtils.trimToNull((String)regexReplacement));
            } else {
                this.addAdditionalUserSuffixToModel(model, additionalUserSuffix);
            }
            model.put("regexEnabled", regexEnabled);
        }
        this.renderUserMappings(resp, kerberosPrincipal, model);
    }
}

