/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.websudo;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.utils.CookieUtil;

public class WebSudoServlet
extends HttpServlet {
    public static final String FORCE_AUTH_SESSION_ID = "ForceAuthSessionId";
    public static final String FORCE_AUTH_INITIATED = "ForceAuthInitiated";
    public static final String FORCED_AUTH_URL_PARAMETER = "ForceAuthn=true";
    protected static final String WEB_SUDO_TARGET = "webSudoTarget";
    protected String WEB_SUDO_SERVLET_URL;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.initiateWebsudo(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter("hasUsedSso") != null) {
            PrintWriter out = resp.getWriter();
            String idpId = (String)req.getSession().getAttribute(FORCE_AUTH_SESSION_ID);
            out.print(idpId != null);
            return;
        }
        this.finishWebsudo(req, resp);
    }

    protected void initiateWebsudo(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpSession session = req.getSession();
        String context = req.getContextPath();
        String username = (String)CookieUtil.getPreviouslyKnownLoginUsername(req).get();
        String usernameParameter = StringUtils.isNotBlank((CharSequence)username) ? "&username=" + username + "&login_hint=" + username : "";
        String idpConfigurationId = (String)session.getAttribute(FORCE_AUTH_SESSION_ID);
        if (idpConfigurationId != null) {
            session.setAttribute(WEB_SUDO_TARGET, (Object)req.getParameter(WEB_SUDO_TARGET));
            resp.sendRedirect(String.format("%s/plugins/servlet/no.kantega.saml/sp/%s/login?%s&target=%s/plugins/servlet/no.kantega.saml/%s%s", context, idpConfigurationId, FORCED_AUTH_URL_PARAMETER, context, this.WEB_SUDO_SERVLET_URL, usernameParameter));
        } else {
            this.sendError(resp);
        }
    }

    protected void finishWebsudo(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpSession session = req.getSession();
        if (session.getAttribute(FORCE_AUTH_SESSION_ID) != null && session.getAttribute(FORCE_AUTH_INITIATED) != null) {
            session.removeAttribute(FORCE_AUTH_INITIATED);
            this.startWebsudoSession(req, resp);
            String target = (String)req.getSession().getAttribute(WEB_SUDO_TARGET);
            if (target == null) {
                target = "/";
            }
            resp.sendRedirect(req.getContextPath() + target);
        } else {
            this.sendError(resp);
        }
    }

    private void sendError(HttpServletResponse resp) throws IOException {
        resp.sendError(400, "Could not determine what identity provider was used during your login. Please press Back and try again.");
    }

    protected void startWebsudoSession(HttpServletRequest req, HttpServletResponse resp) {
    }

    public static void setForcedAuthSessionId(HttpServletRequest request, String idpConfigurationId) {
        request.getSession().setAttribute(FORCE_AUTH_SESSION_ID, (Object)idpConfigurationId);
    }
}

