/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.oidc.OidcData;
import io.vavr.collection.CharSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlXmlParser;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpIntegrationServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final OidcLibWrapper oidcLibWrapper;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IdpConfiguration configuration;
    private String requestId;

    @Inject
    public IdpIntegrationServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.oidcLibWrapper = bucket.getOidcLibWrapper();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.requestId = IdpConfManager.IdpServletUtil.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(this.requestId);
        this.renderPage(req, resp, this.newModel(req));
    }

    private String getMaskedClientSecret() {
        return ((OidcIdpConfiguration)this.configuration).getClientSecret().replaceAll(".", "*");
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(req));
        if (this.configuration.isOidc()) {
            OidcIdpConfiguration idpConfig = (OidcIdpConfiguration)this.configuration;
            List scopesSupported = List.empty();
            String knownIssuer = null;
            Either maybeOidcData = this.oidcLibWrapper.createOidcData((io.vavr.collection.HashMap<String, Object>)io.vavr.collection.HashMap.of((Object)"client_id", (Object)idpConfig.getClientId(), (Object)"client_secret", (Object)idpConfig.getClientSecret(), (Object)"discovery_url", (Object)idpConfig.getDiscoveryUrl(), (Object)"workaround", (Object)idpConfig.getOidcLibRepresentation(), (Object)"issuer_allowlist", (Object)idpConfig.getIssuerAllowList())).flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? this.oidcLibWrapper.discover((OidcData)data) : Either.right((Object)data));
            if (maybeOidcData.isLeft()) {
                this.log.warn(ErrorUtils.createErrorMessage("KSSO-GY912UU9Q2", (String)maybeOidcData.getLeft()));
            } else {
                JSONObject discovery;
                OidcData oidcData = (OidcData)maybeOidcData.get();
                scopesSupported = oidcData.getScopesSupported();
                Option maybeDiscovery = oidcData.get("discovery", JSONObject.class);
                if (!maybeDiscovery.isEmpty() && (discovery = (JSONObject)maybeDiscovery.get()).has("issuer")) {
                    knownIssuer = discovery.getString("issuer");
                }
            }
            model.put("scopesSupported", scopesSupported);
            Set<String> savedScopes = ((OidcIdpConfiguration)this.configuration).getScope();
            model.put("savedScopes", String.join((CharSequence)",", savedScopes));
            model.put("knownIssuer", knownIssuer);
            String[] issuerAllowList = idpConfig.getIssuerAllowList();
            model.put("issuerAllowList", issuerAllowList);
            String issuerAllowListString = ListParseUtils.iterableToCommaSeparatedAndSpacedString(Arrays.asList(issuerAllowList));
            model.put("issuerAllowListString", issuerAllowListString);
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerSettings");
        model.put("usernameAttributes", IdpConfiguration.UsernameAttribute.values());
        model.put("customUsernameAttributeName", this.configuration.getCustomUsernameAttributeName());
        model.put("idp", this.configuration);
        model.put("callbackUrl", ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties));
        model.put("canAddUser", this.hostApp.canAddUser());
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("serviceURL", this.idpConfManager.getServiceProviderLoginUrl(req, this.requestId));
        model.put("testingURL", this.idpConfManager.getServiceProviderTestUrl(req, this.requestId));
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataUrl(req, this.requestId));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("defaultGroups", this.idpConfManager.commaSeparated(this.configuration.getDefaultGroups()));
        model.put("serverName", req.getServerName());
        model.put("activeUserDirectories", this.userLookupService.getActiveUserDirectories());
        model.put("test", req.getParameter("test"));
        if (this.configuration.isOidc()) {
            model.put("maskedClientSecret", this.getMaskedClientSecret());
        }
        this.getTemplateRenderer().render("templates/saml/idp-integration.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String testId;
        String id = IdpConfManager.IdpServletUtil.getId(req);
        String addIssuer = req.getParameter("add-issuer");
        String deleteIssuer = req.getParameter("delete-issuer");
        String action = req.getParameter("action");
        if ("editIdp".equals(action)) {
            IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(id);
            HashMap<String, Boolean> validationErrors = new HashMap<String, Boolean>();
            IdpConfigurationBuilder builder = existing.fold(oidc -> {
                String discoveryUrl;
                IdpConfigurationBuilder.Oidc oidcBuilder = IdpConfigurationBuilder.of(oidc);
                String clientIdParam = StringUtils.trim((String)req.getParameter("clientId"));
                if (StringUtils.isNotEmpty((CharSequence)clientIdParam)) {
                    oidcBuilder.setOidcClientId(clientIdParam);
                } else {
                    validationErrors.put("clientIdRequired", true);
                }
                String clientSecretParam = StringUtils.trim((String)req.getParameter("clientSecret"));
                if (StringUtils.isNotEmpty((CharSequence)clientSecretParam)) {
                    if (!clientSecretParam.equals(this.getMaskedClientSecret())) {
                        oidcBuilder.setOidcClientSecret(clientSecretParam);
                    }
                } else {
                    validationErrors.put("clientSecretRequired", true);
                }
                if (StringUtils.isNotEmpty((CharSequence)(discoveryUrl = StringUtils.trim((String)req.getParameter("discoveryUrl"))))) {
                    if (HttpUrlUtils.validateURI(discoveryUrl)) {
                        oidcBuilder.setOidcDiscoveryUrl(discoveryUrl);
                    } else {
                        validationErrors.put("discoveryUrlInvalid", true);
                    }
                }
                String oidcScopesString = StringUtils.trim((String)req.getParameter("oidcScopes"));
                LinkedHashSet<String> oidcScopes = SamlXmlParser.parseSet(oidcScopesString);
                oidcBuilder.setScopes(oidcScopes);
                List oidcIssuerAllowList = ((Seq)Option.of((Object)req.getParameter("issuerAllowListString")).map(StringUtils::deleteWhitespace).map(CharSeq::of).map(charSeq -> charSeq.split(",")).getOrElse((Object)Vector.empty())).map(CharSeq::toString).toList();
                if (Objects.nonNull(deleteIssuer)) {
                    oidcIssuerAllowList = oidcIssuerAllowList.filter(issuer -> !Objects.equals(issuer, deleteIssuer));
                } else if (Objects.nonNull(addIssuer)) {
                    oidcIssuerAllowList = (List)Option.of((Object)req.getParameter("add-issuer-value")).map(StringUtils::deleteWhitespace).map(arg_0 -> ((List)oidcIssuerAllowList).push(arg_0)).getOrElse((Object)oidcIssuerAllowList);
                }
                String[] oidcIssuerAllowArray = oidcIssuerAllowList.asJava().toArray(new String[0]);
                oidcBuilder.setIssuerAllowList(oidcIssuerAllowArray);
                return oidcBuilder;
            }, saml -> {
                IdpConfigurationBuilder.Saml samlBuilder = IdpConfigurationBuilder.of(saml);
                String location = StringUtils.trim((String)req.getParameter("location"));
                if (!StringUtils.isEmpty((CharSequence)location)) {
                    if (HttpUrlUtils.validateURI(location)) {
                        samlBuilder.setIdpUrl(location);
                    } else {
                        validationErrors.put("locationInvalid", true);
                    }
                } else {
                    validationErrors.put("locationRequired", true);
                }
                return samlBuilder;
            });
            String name = StringUtils.trim((String)req.getParameter("name"));
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                builder.setName(name);
            } else {
                validationErrors.put("nameRequired", true);
            }
            String userLookupAttributeParam = StringUtils.trim((String)req.getParameter("userLookupAttribute"));
            if (!StringUtils.isEmpty((CharSequence)userLookupAttributeParam)) {
                builder.setUserLookupAttribute(IdpConfiguration.UserLookupAttribute.valueOf(userLookupAttributeParam));
            }
            if (!validationErrors.isEmpty()) {
                Map<String, Object> model = this.newModel(req);
                model.putAll(validationErrors);
                model.put("activeTab", "location");
                this.renderPage(req, resp, model);
                return;
            }
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        if ((testId = req.getParameter("test")) != null) {
            resp.sendRedirect(this.idpConfManager.getServiceProviderEvaluateTestUrl(req, id) + "?id=" + testId);
        } else {
            resp.sendRedirect("idp-integration");
        }
    }
}

