/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import io.vavr.control.Option;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public class SamlIdpConfiguration
extends IdpConfiguration {
    public static final String IDP_ID_SESSION_KEY = "ksso.saml.idp.id";
    public static final String SESSION_USER = "ksso.saml.session.user";
    public static final String DEFAULT_AUTHN_CONTEXT_CLASS_REF = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
    private final String idpURL;
    private final List<byte[]> signingCerts;
    private final boolean encryptedAssertionsRequired;
    private final boolean instantLoginUrlInSession;
    private final boolean usePostBinding;
    private final String metadataURL;
    private final String singleLogoutServiceURL;
    private final String tlsFingerprint;
    private final RequestedAuthnContextPolicy requestedAuthnContextPolicy;
    private final RequestedAuthnContextComparison requestedAuthnContextComparison;
    private final String authnContextClassRef;
    private final IssuerPolicy issuerPolicy;
    private final String issuer;
    private final IdpConfiguration.AllowCreate allowCreate;
    private final IdpConfiguration.NameIdFormat nameIdFormat;
    private final String customNameIdFormat;
    private final SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy;
    private final boolean autoRefreshMetadataEnabled;

    public SamlIdpConfiguration(boolean mfaRequired, String mfaAttribute, IdpConfiguration.AllowCreate allowCreate, Set<String> defaultGroups, Map<String, String> defaultGroupsRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customGivenNameAttribute, String customSurnameAttribute, IdpConfManager.NAME_ATTRIBUTE_MAPPING nameAttributeMapping, String customUsernameAttributeName, boolean enabled, String id, Optional<Long> jitDirectory, IdpConfiguration.Kind kind, LinkedHashSet<String> knownDomains, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, List<ManagedGroup> autoGroups, boolean managedGroupsRequiredForJITCreation, String name, String notificationEmails, List<Pair<String, String>> userTransformationRegexes, boolean singleLogoutEnabled, IdpConfiguration.UserActivatePolicy userActivatePolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UsernamePolicy usernamePolicy, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserUpdatePolicy userUpdatePolicy, IdpConfiguration.AutoCreateUserPolicy autoCreateUserPolicy, boolean hostedDomain, Set<String> idpGroupsAttribute, Map<String, String> userProfileKeyTransformations, boolean authenticatedAnonymousBrowsingEnabled, String authnContextClassRef, String customNameIdFormat, boolean encryptedAssertionsRequired, boolean instantLoginUrlInSession, boolean usePostBinding, String idpURL, String issuer, IssuerPolicy issuerPolicy, String metadataURL, IdpConfiguration.NameIdFormat nameIdFormat, SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy, List<byte[]> signingCerts, String singleLogoutServiceURL, String singleLogoutReturnURL, String tlsFingerprint, RequestedAuthnContextComparison requestedAuthnContextComparison, RequestedAuthnContextPolicy requestedAuthnContextPolicy, boolean autoRefreshMetadataEnabled, RedirectProperties redirectProperties, RedirectProperties jsmRedirectProperties) {
        super(mfaRequired, mfaAttribute, defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customGivenNameAttribute, customSurnameAttribute, nameAttributeMapping, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, autoGroups, managedGroupsRequiredForJITCreation, name, notificationEmails, userTransformationRegexes, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdatePolicy, autoCreateUserPolicy, hostedDomain, idpGroupsAttribute, singleLogoutReturnURL, userProfileKeyTransformations, authenticatedAnonymousBrowsingEnabled, redirectProperties, jsmRedirectProperties);
        this.idpURL = idpURL;
        this.signingCerts = signingCerts;
        this.encryptedAssertionsRequired = encryptedAssertionsRequired;
        this.instantLoginUrlInSession = instantLoginUrlInSession;
        this.usePostBinding = usePostBinding;
        this.metadataURL = metadataURL;
        this.singleLogoutServiceURL = singleLogoutServiceURL;
        this.sessionIdentificationValidationPolicy = sessionIdentificationValidationPolicy;
        this.tlsFingerprint = tlsFingerprint;
        this.requestedAuthnContextPolicy = requestedAuthnContextPolicy;
        this.requestedAuthnContextComparison = requestedAuthnContextComparison;
        this.authnContextClassRef = authnContextClassRef;
        this.issuerPolicy = issuerPolicy;
        this.issuer = issuer;
        this.nameIdFormat = nameIdFormat;
        this.customNameIdFormat = customNameIdFormat;
        this.allowCreate = allowCreate;
        this.autoRefreshMetadataEnabled = autoRefreshMetadataEnabled;
    }

    @Override
    public IdpConfiguration.SSOProtocol getProtocol() {
        return IdpConfiguration.SSOProtocol.SAML;
    }

    public IssuerPolicy getIssuerPolicy() {
        return this.issuerPolicy;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIdpURL() {
        return this.idpURL;
    }

    public String getMetadataUrl() {
        return this.metadataURL;
    }

    public String getSingleLogoutServiceURL() {
        return this.singleLogoutServiceURL;
    }

    public String getTlsFingerprint() {
        return this.tlsFingerprint;
    }

    public boolean supportForceAuthn() {
        return this.getIdpURL() != null && this.getIdpURL().contains("/adfs/ls");
    }

    public List<byte[]> getSigningCerts() {
        return this.signingCerts;
    }

    public RequestedAuthnContextPolicy getRequestedAuthnContextPolicy() {
        return this.requestedAuthnContextPolicy;
    }

    public RequestedAuthnContextComparison getRequestedAuthnContextComparison() {
        return this.requestedAuthnContextComparison;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public IdpConfiguration.NameIdFormat getNameIdFormat() {
        return this.nameIdFormat;
    }

    public String getCustomNameIdFormat() {
        return this.customNameIdFormat;
    }

    public boolean isEncryptedAssertionsRequired() {
        return this.encryptedAssertionsRequired;
    }

    public boolean isInstantLoginUrlInSession() {
        return this.instantLoginUrlInSession;
    }

    public boolean isUsePostBinding() {
        return this.usePostBinding;
    }

    public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy() {
        return this.sessionIdentificationValidationPolicy;
    }

    public IdpConfiguration.AllowCreate getAllowCreate() {
        return this.allowCreate;
    }

    public boolean isAutoRefreshMetadataEnabled() {
        return this.autoRefreshMetadataEnabled;
    }

    @Override
    public boolean isOidc() {
        return false;
    }

    @Override
    public boolean isSaml() {
        return true;
    }

    @Override
    public IdpConfiguration.UsernameAttribute getUsernameAttribute() {
        return (IdpConfiguration.UsernameAttribute)((Object)Option.of((Object)((Object)this.usernameAttribute)).getOrElse((Object)this.getKind().getDefaultUsernameAttribute(IdpConfiguration.SSOProtocol.SAML)));
    }

    @Override
    public JSONObject asJson() {
        CertTool certTool = new CertTool();
        JSONObject json = super.asJson();
        json.put("idpURL", (Object)this.getIdpURL());
        json.put("signingCerts", (Object)new JSONArray((Collection)io.vavr.collection.List.ofAll(this.getSigningCerts()).map(bytes -> {
            X509Certificate cert = CertTool.parse(bytes);
            JSONObject certJson = new JSONObject();
            certJson.put("subjectDn", (Object)cert.getSubjectDN().getName());
            certJson.put("notBefore", (Object)cert.getNotBefore().toString());
            certJson.put("notAfter", (Object)cert.getNotAfter().toString());
            certJson.put("sigAlgName", (Object)cert.getSigAlgName());
            certJson.put("keySize", (Object)String.valueOf(certTool.getKeySize(cert)));
            certJson.put("fingerPrint", (Object)CertTool.fingerPrint(bytes));
            return certJson;
        }).asJava()));
        json.put("encryptedAssertionsRequired", this.isEncryptedAssertionsRequired());
        json.put("instantLoginUrlInSession", this.isInstantLoginUrlInSession());
        json.put("usePostBinding", this.isUsePostBinding());
        json.put("metadataURL", (Object)this.getMetadataUrl());
        json.put("singleLogoutServiceURL", (Object)this.getSingleLogoutServiceURL());
        json.put("tlsFingerprint", (Object)this.getTlsFingerprint());
        json.put("requestedAuthnContextPolicy", (Object)this.getRequestedAuthnContextPolicy().name());
        json.put("requestedAuthnContextComparison", (Object)this.getRequestedAuthnContextComparison().name());
        json.put("authnContextClassRef", (Object)this.getAuthnContextClassRef());
        json.put("issuerPolicy", (Object)this.getIssuerPolicy().name());
        json.put("issuer", (Object)this.getIssuer());
        json.put("allowCreate", (Object)this.getAllowCreate().name());
        json.put("nameIdFormat", (Object)this.getNameIdFormat().name());
        json.put("customNameIdFormat", (Object)this.getCustomNameIdFormat());
        json.put("sessionIdentificationValidationPolicy", (Object)((SAMLSessionIdentification.ValidationPolicy)Option.of((Object)this.getSessionIdentificationValidationPolicy()).getOrElse((Object)SAMLSessionIdentification.ValidationPolicy.getDefault())).name());
        return json;
    }

    public static enum IssuerPolicy {
        DEFAULT,
        CUSTOM;

    }

    public static enum RequestedAuthnContextComparison {
        EXACT,
        MINIMUM,
        MAXIMUM,
        BETTER;

    }

    public static enum RequestedAuthnContextPolicy {
        DO_NOT_SEND,
        CUSTOM;

    }
}

