/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import java.util.Map;
import org.json.JSONObject;

enum IdpValidationError {
    KIND("kind", "Not a valid kind. Check for typos."),
    DISPLAY_NAME("display_name", "The IDP name must exist, and only consist of alphanumeric characters and <space>, -, _, ."),
    MISSING_VALUES("missing_values", "No viable strategy for creating an IDP with the provided values."),
    OIDC_CLIENT_ID("client_id", "Client id must exist, and can not be a blank String."),
    OIDC_CLIENT_SECRET("client_secret", "Client secret can not be more than 6000 characters long."),
    OIDC_DISCOVERY_URL("discovery_url", "Discovery URL must exist, and point to a valid discovery document. The resource must be reachable by the server."),
    OIDC_SCOPE("scope", "scope must exist, be a JSONArray, and contain 'openid'."),
    SAML_LOCATION("location", "saml_location must be a valid URI."),
    SAML_METADATA_URL("metadata_url", "SAML metadata URI must be a valid URI."),
    SAML_CERTIFICATES("certificates", "SAML certificates must be a JSONArray of Base64-encoded x509-certificates."),
    SAML_TLS_FINGERPRINT("tls_fingerprint", ""),
    IDP_ID("idp_id", "Idp id must be an alphanumeric string between 1 and 20 characters.");

    private final String description;
    private final String shortName;

    private IdpValidationError(String shortName, String description) {
        this.shortName = shortName;
        this.description = description;
    }

    public JSONObject asJson() {
        return new JSONObject((Map)HashMap.of((Object)"type", (Object)this.name(), (Object)"description", (Object)this.description).toJavaMap());
    }

    public Tuple2<String, String> asTuple() {
        return API.Tuple((Object)this.name(), (Object)this.description);
    }

    public Tuple2<String, String> asShortNameTuple() {
        return API.Tuple((Object)this.shortName, (Object)this.description);
    }
}

