/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crucible.spi.services.GlobalPermissionService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.GroupName;
import com.atlassian.fisheye.spi.data.MailMessageData;
import com.atlassian.fisheye.spi.services.MailService;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenqua.fisheye.user.GroupMembershipManager;
import io.vavr.NotImplementedError;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FecruHostApp
extends DefaultHostApp {
    private final MailService mailService;
    private final GlobalPermissionService globalPermissionService;
    private final GroupMembershipManager groupMembershipManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public FecruHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager);
        this.preemptivePathMappings.add("/cru");
        this.preemptivePathMappings.add("/cru/*");
        this.preemptivePathMappings.add("/projects");
        this.preemptivePathMappings.add("/projects/*");
        this.preemptivePathMappings.add("/browse");
        this.preemptivePathMappings.add("/browse/*");
        this.preemptivePathMappings.add("/changelog");
        this.preemptivePathMappings.add("/users");
        this.preemptivePathMappings.add("/user/*");
        this.mailService = (MailService)ComponentLocator.getComponent(MailService.class);
        this.globalPermissionService = (GlobalPermissionService)ComponentLocator.getComponent(GlobalPermissionService.class);
        this.groupMembershipManager = (GroupMembershipManager)ComponentLocator.getComponent(GroupMembershipManager.class);
    }

    @Override
    public boolean addUserToGroup(Principal principal, String groupName) {
        return this.groupMembershipManager.tryAddUserToGroup(GroupName.create((String)groupName), principal.getName());
    }

    @Override
    public boolean removeUserFromGroup(Principal principal, String groupName) {
        try {
            this.groupMembershipManager.removeUserFromGroup(GroupName.create((String)groupName), principal.getName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req, String requestUrl) {
        return this.isMainLoginPage(requestUrl) || requestUrl.startsWith("/WEB-INF/jsp/login.jsp");
    }

    @Override
    public boolean isMainLoginPage(String requestUrl) {
        return requestUrl.startsWith(this.getLoginPage());
    }

    @Override
    public String getLoginPage() {
        return "/login";
    }

    @Override
    public String getLogoutPage() {
        return "/logout";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5505;
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequest request) {
        String username = user.getName();
        return this.globalPermissionService.hasUserPermissions(username, GlobalPermissionType.CRUCIBLE_USER) || this.globalPermissionService.hasUserPermissions(username, GlobalPermissionType.FISHEYE_USER);
    }

    @Override
    public boolean isProductMatch(String product) {
        return StringUtils.equalsIgnoreCase((CharSequence)"fecru", (CharSequence)product);
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/userAdd-default.do";
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        String forwardedUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedUri != null) {
            return req.getRequestURI().endsWith("/WEB-INF/jsp/login.jsp") || forwardedUri.equals(req.getContextPath() + "/");
        }
        return r.equals("/");
    }

    @Override
    public boolean isPreemptiveRequestMapped(HttpServletRequest req) {
        String f = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (f != null) {
            f = f.substring(req.getContextPath().length());
            return super.isPreemptiveRequestMapped(req) || f.equals("/cru") || f.startsWith("/cru/") || f.equals("/projects") || f.startsWith("/project/") || f.equals("/browse") || f.startsWith("/browse/") || f.equals("/changelog") || f.equals("/users") || f.startsWith("/user/");
        }
        return false;
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String returnUrl = this.getRedirectTarget(req);
        if (req.getQueryString() == null) {
            this.metaRefresh(resp, req.getContextPath() + "/login?origUrl=" + HttpUrlUtils.urlEncode(returnUrl));
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(user), req, res);
        req.getSession().setAttribute("feuser", req.getAttribute("feuser"));
        return user;
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        return (req.getContextPath() + "/login").equals(req.getRequestURI());
    }

    @Override
    public boolean isPasswordLoginRequest(HttpServletRequest req) {
        return StringUtils.isNotBlank((CharSequence)req.getParameter("password")) || StringUtils.isNotBlank((CharSequence)req.getParameter("adminPassword"));
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("username");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        String reqUrl = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (reqUrl == null) {
            return false;
        }
        return (req.getContextPath() + "/login").equals(reqUrl) && this.getRedirectTarget(req) == null;
    }

    @Override
    protected boolean isAppLoggedIn(HttpSession session) {
        return session.getAttribute("feuser") != null;
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException {
        this.preventCaching(res);
        String origUrl = req.getParameter("origUrl");
        if (origUrl != null) {
            this.safeRedirect.sendRedirect(origUrl, req, res);
        } else {
            String url = (String)req.getAttribute("javax.servlet.forward.request_uri");
            if (url == null) {
                url = req.getRequestURI();
            }
            if (url != null) {
                String queryString = req.getQueryString();
                if (queryString != null) {
                    url = url + "?" + queryString;
                }
                res.sendRedirect(url);
            } else {
                res.sendRedirect(req.getContextPath() + "/");
            }
        }
    }

    @Override
    public String getRedirectTarget(HttpServletRequest req) {
        String returnUrl = req.getParameter("origUrl");
        if (returnUrl == null && req.getSession() != null) {
            returnUrl = (String)req.getSession().getAttribute("com.cenqua.fisheye.web.LoginServlet.ORIG_URL");
        }
        return returnUrl;
    }

    @Override
    public boolean isSMTPSupported() {
        return true;
    }

    @Override
    public boolean isSMTPEnabled() {
        return this.mailService.isConfigured();
    }

    @Override
    public void sendEmail(String recipient, String subject, String body) {
        MailMessageData message = new MailMessageData();
        message.addRecipient(recipient);
        message.setSubject(subject);
        message.setBodyText("text/plain", body);
        this.mailService.sendMessage(message);
    }

    @Override
    public boolean isRestApi(String internalPath) {
        return (Boolean)Option.of((Object)internalPath).map(path -> path.startsWith("/rest-service-fecru/") || path.startsWith("/rest-service/") || path.startsWith("/rest/")).getOrElse((Object)false);
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequest request) {
        return (Boolean)Option.of((Object)request).map(HttpUrlUtils::getInternalPath).filter(this::isRestApi).map(internalPath -> internalPath.contains("applinks")).getOrElse((Object)false);
    }

    @Override
    public List<String> getUserProfileKeys() {
        return List.empty();
    }

    @Override
    public void setUserProfileValue(String username, String key, String value) {
    }

    @Override
    public String getUserProfileValue(String username, String key) {
        return "";
    }

    @Override
    public void setUserProfilePicture(String username, String url) {
        throw new NotImplementedError("Awaiting investigation of security features in Atlassian products.");
    }
}

