/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.diagnostics;

import com.kantegasso.jsonmapping.JsonMapping;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DiagnosticsLog {
    private final Logger log = LoggerFactory.getLogger((String)"com.kantegasso.DiagnosticsLog");

    public void loginFailed(String context, String reason, Date timestamp) {
        DiagnosticsLogElement element = new DiagnosticsLogElement();
        if (timestamp != null) {
            element.setTimestamp(timestamp);
        } else {
            element.setTimestamp(new Date());
        }
        element.setContext(context);
        element.setMessage("Authentication has FAILED" + reason);
        this.log.warn((String)JsonMapping.Write.objectAsJson((Object)element).mapTry(JSONObject::toString).getOrElse((Object)String.format("[%s] %s %s", element.getTimestamp(), element.getContext(), element.getMessage())));
    }

    static class DiagnosticsLogElement {
        private Date timestamp;
        private String context;
        private String message;

        DiagnosticsLogElement() {
        }

        public String getTimestamp() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            return sdf.format(this.timestamp);
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

