/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.apiserver.ApiServer;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.ScimTransform;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupService {
    public static final String BACKUP_DIR = "SNAPSHOT/";
    public static final String PLUGIN_SETTINGS_PROPERTIES = "SNAPSHOT/plugin-settings.properties";
    public static final String BACKUP_PROPERTIES = "SNAPSHOT/snapshot.properties";
    public static final String SCIM_DIR = "SNAPSHOT/scim/";
    public static final String SCIM_DIRECTORIES_FILE = "SNAPSHOT/scim/scim-directories.json";
    private final Logger log = LoggerFactory.getLogger(BackupService.class);
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ConnectorConfManager connectorConfManager;
    private final ApiServerConfManager apiServerConfManager;
    private final ApiServer apiServer;
    private final ApplicationProperties applicationProperties;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final ScimConfManager scimConfManager;

    @Inject
    public BackupService(@ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostAppFactory, KerbConfManager kerbConfManager, IdpConfManager idpConfManager, ConnectorConfManager connectorConfManager, ApiServerConfManager apiServerConfManager, ApiServer apiServer, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, ScimConfManager scimConfManager) {
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = kerbConfManager;
        this.idpConfManager = idpConfManager;
        this.connectorConfManager = connectorConfManager;
        this.apiServerConfManager = apiServerConfManager;
        this.apiServer = apiServer;
        this.applicationProperties = applicationProperties;
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.scimConfManager = scimConfManager;
    }

    public void restoreFromFile(File backupFile, boolean makeBackup) {
        if (makeBackup) {
            File file = this.createBackup("Before restore of " + backupFile.getName());
        }
        File homeDirectory = this.hostApp.getHomeDirectory();
        File unpackDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_restore");
        File oldHomeDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_oldhome");
        try {
            ZipInputStream in = new ZipInputStream(new FileInputStream(backupFile));
            ZipEntry entry = null;
            Properties props = new Properties();
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                if (entry.getName().equals(PLUGIN_SETTINGS_PROPERTIES)) {
                    props.load(in);
                    continue;
                }
                if (!entry.getName().startsWith(BACKUP_DIR)) {
                    File file = new File(unpackDir, entry.getName());
                    file.getParentFile().mkdirs();
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                    continue;
                }
                if (!entry.getName().equals(SCIM_DIRECTORIES_FILE)) continue;
                this.restoreScimDirectories(in);
            }
            FileUtils.deleteDirectory((File)oldHomeDir);
            homeDirectory.renameTo(oldHomeDir);
            unpackDir.renameTo(homeDirectory);
            FileUtils.deleteDirectory((File)oldHomeDir);
            List<Directory> needsUpdate = this.apiServer.findConnectorDirectoriesToUpdate();
            this.kerbConfManager.restoreSettings(props);
            this.idpConfManager.restoreSettings(props);
            this.connectorConfManager.restoreSettings(props);
            this.apiServerConfManager.restoreSettings(props);
            this.apiTokenService.restoreTokens(props);
            this.tokenEndpointService.restoreEndpoints(props);
            this.scimConfManager.restoreSettings(props);
            this.kerbConfManager.flushCaches();
            this.apiServer.configChanged(this.apiServerConfManager.getConfig());
            this.apiServer.updateConnectorDirectories(needsUpdate, this.apiServerConfManager.getCrowdServerUrl());
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)unpackDir);
            }
            catch (IOException iOException) {}
        }
    }

    public File createBackup(String description) {
        BackupInfo backupInfo = this.getBackupInfo(description);
        final File homeDirectory = this.hostApp.getHomeDirectory();
        File backupsDirectory = this.getBackupsDirectory();
        File tempFile = new File(backupsDirectory, "_backup_zip.tmp");
        tempFile.getParentFile().mkdirs();
        try (final ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
            this.writeMetadata(out, backupInfo);
            this.writeDbSettings(out);
            this.writeScimDirectories(out, this.scimConfManager.findScimDirectories());
            if (homeDirectory.exists()) {
                Files.walkFileTree(homeDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        ZipEntry entry = new ZipEntry(homeDirectory.toPath().relativize(path).toString());
                        out.putNextEntry(entry);
                        Files.copy(path, out);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create KSSO backup tempfile: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            File backupFile = new File(tempFile.getParentFile(), this.filename());
            Path backupFilePath = Paths.get(backupFile.getAbsolutePath(), new String[0]);
            Path tempFilePath = Paths.get(tempFile.getAbsolutePath(), new String[0]);
            Files.move(tempFilePath, backupFilePath, StandardCopyOption.REPLACE_EXISTING);
            return backupFile;
        }
        catch (IOException e) {
            this.log.error("Failed to finalize the creation of KSSO backup .zip file: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private BackupInfo getBackupInfo(String description) {
        new PluginKey();
        return new BackupInfo(this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), PluginKey.getVersion(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), System.currentTimeMillis(), description, this.filename());
    }

    @NotNull
    public String filename() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH_mm_ss");
        return "sso-backup-" + df.format(new Date()) + ".zip";
    }

    private void writeDbSettings(ZipOutputStream out) throws IOException {
        ZipEntry propsFile = new ZipEntry(PLUGIN_SETTINGS_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties props = this.getDbSettings();
        props.store(out, null);
    }

    private void writeMetadata(ZipOutputStream out, BackupInfo backupInfo) throws IOException {
        ZipEntry propsFile = new ZipEntry(BACKUP_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties settings = backupInfo.getProperties();
        settings.store(out, null);
    }

    public void restoreScimDirectories(InputStream is) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        ScimTransform scimTransform = (ScimTransform)mapper.readValue(is, ScimTransform.class);
        List storedTenantIds = io.vavr.collection.List.ofAll(scimTransform.scimDirectoryTransforms).map(dir -> dir.attrs.get("ksso.scim.tenantId")).toJavaList();
        this.scimConfManager.getScimDirectories().filter(scimDirectory -> !storedTenantIds.contains(scimDirectory.getTenantId())).forEach(scimDirectory -> this.scimConfManager.deleteInternalDirectory(scimDirectory.getDirectoryId()));
        scimTransform.scimDirectoryTransforms.forEach(scimDirTransform -> this.scimConfManager.restoreScimDirectory(scimDirTransform.name, scimDirTransform.attrs));
    }

    private void writeScimDirectories(ZipOutputStream out, Map<String, Directory> scimDirectories) throws IOException {
        if (scimDirectories.size() < 1) {
            return;
        }
        ScimTransform scimOverview = new ScimTransform(scimDirectories);
        out.putNextEntry(new ZipEntry(SCIM_DIRECTORIES_FILE));
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jsonFactory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.writeValue((OutputStream)out, (Object)scimOverview);
        out.closeEntry();
    }

    private Properties getDbSettings() {
        Properties props = new Properties();
        props.putAll(this.kerbConfManager.getSettings());
        props.putAll(this.idpConfManager.getSettings());
        props.putAll(this.connectorConfManager.getSettings());
        props.putAll(this.apiServerConfManager.getSettings());
        props.put("apiTokens", this.apiTokenService.getAllTokensAsJsonForBackup());
        props.put("restrictAPIEndpoints", this.tokenEndpointService.getAllEndpointsAsJson());
        props.putAll(this.scimConfManager.getSettings());
        return props;
    }

    public File getBackupsDirectory() {
        File homeDirectory = this.hostApp.getHomeDirectory();
        return new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_snapshots");
    }

    public List<BackupInfo> getBackups() {
        File[] files = this.getBackupsDirectory().listFiles(pathname -> pathname.getName().endsWith(".zip"));
        if (files == null) {
            return Collections.emptyList();
        }
        Arrays.sort(files, (o1, o2) -> Long.compare(o2.lastModified(), o1.lastModified()));
        ArrayList<BackupInfo> result = new ArrayList<BackupInfo>();
        for (File file : files) {
            if (!file.canRead()) {
                result.add(new BackupInfo(file.getName(), false));
                continue;
            }
            try (ZipFile zip = new ZipFile(file);){
                ZipEntry metaEntry = zip.getEntry(BACKUP_PROPERTIES);
                ZipEntry settingsEntry = zip.getEntry(PLUGIN_SETTINGS_PROPERTIES);
                if (metaEntry == null || settingsEntry == null) continue;
                Properties props = new Properties();
                props.load(zip.getInputStream(metaEntry));
                BackupInfo info = BackupInfo.fromProperties(props, file.getName());
                result.add(info);
                Properties settings = new Properties();
                settings.load(zip.getInputStream(settingsEntry));
                info.setSettings(settings);
                TreeSet<String> paths = new TreeSet<String>();
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().startsWith(BACKUP_DIR)) continue;
                    paths.add(entry.getName());
                }
                info.getPaths().addAll(paths);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public boolean isBackup(String filename) {
        return io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).isDefined();
    }

    public BackupInfo findBackup(String filename) {
        return (BackupInfo)io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).getOrNull();
    }

    public Option<File> getBackupFile(String filename) {
        return io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).map(backupInfo -> new File(this.getBackupsDirectory(), backupInfo.getFilename()));
    }
}

