/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.CheckedFunction0;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdatePluginSettingsEntryResult;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;

public class ApiTokenMainServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final KssoUpdateManager kssoUpdateManager;

    @Inject
    public ApiTokenMainServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.userLookupService = bucket.getUserLookupService();
        this.kssoUpdateManager = bucket.getKssoUpdateManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp, new java.util.HashMap<String, Object>());
    }

    private boolean hasUpdateFailures() {
        return this.kssoUpdateManager.getUpdateFailures().exists(upgradeConfigResult -> upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST || upgradeConfigResult.getOldConfigurationKey() == KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.doPost(req, resp);
        HashMap protoModel = HashMap.empty();
        if (req.getParameter("setApiTokens") != null) {
            String apiTokens = req.getParameter("apiTokens");
            this.kerbConfManager.setApiTokensEnabled("on".equals(apiTokens));
        }
        this.buildModelAndRenderTemplate(req, resp, protoModel.merge(this.setUserPermissions(req)).merge(this.setIpRestrictions(req)).merge(this.setTimeRestriction(req)).toJavaMap());
    }

    private HashMap<String, Object> setTimeRestriction(HttpServletRequest req) {
        if (req.getParameter("userMaxValidFor") != null) {
            String maxvalidfor = req.getParameter("userMaxValidFor");
            if (!ApiTokenUtil.Validation.validTokenTimeLimit(maxvalidfor)) {
                return HashMap.of((Object)"invalidTokenTimeLimitError", (Object)true);
            }
            this.kerbConfManager.setApiTokensUserMaxTimeRestriction(maxvalidfor);
        }
        return HashMap.empty();
    }

    private HashMap<String, Object> setUserPermissions(HttpServletRequest req) {
        Try userPermission;
        if (req.getParameter("apiTokenUserPermission") != null && (userPermission = Try.of((CheckedFunction0 & Serializable)() -> ApiTokenUtil.TokenUserPermission.valueOf(req.getParameter("apiTokenUserPermission")))).isSuccess()) {
            this.kerbConfManager.setApiTokenUserPermission((ApiTokenUtil.TokenUserPermission)((Object)userPermission.get()));
            if (userPermission.get() == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
                String commaSeparatedAllowedUserGroups = req.getParameter("apiTokenAllowedUserGroups");
                if (commaSeparatedAllowedUserGroups == null || StringUtils.isBlank((CharSequence)commaSeparatedAllowedUserGroups)) {
                    this.kerbConfManager.setApiTokenAllowedUserGroups("");
                    return HashMap.of((Object)"userGroupsEmptyWarning", (Object)true, (Object)"apiTokenUserPermission", (Object)((ApiTokenUtil.TokenUserPermission)((Object)userPermission.get())).name());
                }
                this.kerbConfManager.setApiTokenAllowedUserGroups(commaSeparatedAllowedUserGroups);
            }
        }
        return HashMap.empty();
    }

    private String invalidGroupName(List<String> allowedUserGroups) {
        Option maybeNotExistingGroup = io.vavr.collection.List.ofAll(allowedUserGroups).find(g -> !this.hostApp.isExistingGroup((String)g));
        return (String)maybeNotExistingGroup.getOrElse((Object)"");
    }

    private HashMap<String, Object> setIpRestrictions(HttpServletRequest req) throws IOException {
        if (req.getParameter("setIpRestrictions") != null) {
            String ipRestrictionTypeParam = req.getParameter("ipRestrictionType");
            String ipUnblockedList = req.getParameter("token_ip_unblockedlist");
            String ipBlockedList = req.getParameter("token_ip_blockedlist");
            java.util.HashMap<String, Boolean> protomodel = new java.util.HashMap<String, Boolean>();
            Option.of((Object)ipRestrictionTypeParam).filter(StringUtils::isNotBlank).toTry().mapTry(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).peek(this.kerbConfManager::setApiTokenIpRestrictionType);
            Option maybeValidUnblockedList = Option.of((Object)ipUnblockedList).filter(InternetAddressUtils::isValidPermissionList).peek(_list -> {
                if (this.hasUpdateFailures()) {
                    this.kssoUpdateManager.removeUpdateFailureAfterFix(KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setApiTokenIpUnblockedList).onEmpty(() -> protomodel.put("tokenIpUnblockedList", (Boolean)((Object)ipUnblockedList))).onEmpty(() -> protomodel.put("tokenRegexFailedUnblockedList", true)).onEmpty(() -> protomodel.put("invalidDataInIpUnblockedlist", (Boolean)Option.of((Object)ipUnblockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull()));
            Option maybeValidBlockedList = Option.of((Object)ipBlockedList).filter(InternetAddressUtils::isValidPermissionList).peek(_list -> {
                if (this.hasUpdateFailures()) {
                    this.kssoUpdateManager.removeUpdateFailureAfterFix(KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST);
                }
            }).peek(this.kerbConfManager::setApiTokenIpBlockedList).onEmpty(() -> protomodel.put("tokenIpBlockedList", (Boolean)((Object)ipBlockedList))).onEmpty(() -> protomodel.put("tokenRegexFailedBlockedList", true)).onEmpty(() -> protomodel.put("invalidDataInIpBlockedlist", (Boolean)Option.of((Object)ipBlockedList).map(ListParseUtils::parseListFromNewlines).map(KssoUpdateManager::onlyIpRestrictErrorMessagesCommaSeparated).getOrNull()));
            boolean success = io.vavr.collection.List.of((Object[])new Option[]{maybeValidUnblockedList, maybeValidBlockedList}).forAll(Option::isDefined);
            if (!success) {
                protomodel.put("tokenRegexError", true);
            }
            return HashMap.ofAll(protomodel);
        }
        return HashMap.empty();
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalData);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-main.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens-main");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.putIfAbsent("durationOptions", ApiTokenUtil.DatePair.getDurationOptions());
        model.putIfAbsent("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.putIfAbsent("tokenIpRestrictionType", ipRestrictionConfig.getApiTokenRestrictionType().name());
        model.putIfAbsent("tokenIpUnblockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(ipRestrictionConfig.getApiTokenIpUnblockedList())));
        model.putIfAbsent("tokenIpBlockedList", StringUtils.trimToNull((String)ListParseUtils.arrayToStringWithNewlines(ipRestrictionConfig.getApiTokenIpBlockedList())));
        model.putIfAbsent("isRestApiRestrictedToToken", this.kerbConfManager.isRestApiRestrictedToApiTokens());
        ApiTokenUtil.TokenUserPermission tokenUserPermission = this.kerbConfManager.getApiTokenUserPermission();
        model.putIfAbsent("apiTokenUserPermission", (Object)tokenUserPermission);
        String commaSeparatedAllowedGroups = ListParseUtils.iterableToCommaSeparatedString(this.kerbConfManager.getApiTokenAllowedUserGroups());
        model.putIfAbsent("allowedUserGroups", commaSeparatedAllowedGroups);
        if (StringUtils.isBlank((CharSequence)commaSeparatedAllowedGroups) && tokenUserPermission == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
            model.putIfAbsent("userGroupsEmptyWarning", true);
        }
        model.putIfAbsent("apiTokensUserMaxTimeRestriction", this.kerbConfManager.getApiTokensUserMaxTimeRestriction());
        String invalidGroupName = this.invalidGroupName(this.kerbConfManager.getApiTokenAllowedUserGroups());
        if (!invalidGroupName.isEmpty()) {
            model.putIfAbsent("invalidGroupName", invalidGroupName);
        }
        Try.of((CheckedFunction0 & Serializable)() -> this.userManager.getRemoteUser(req)).mapTry(UserProfile::getUsername).peek(username -> model.putIfAbsent("username", username));
        model.putIfAbsent("tokens", this.getTokensRepresentation());
        model.putIfAbsent("hasApiTokenIpUpgradeFailures", this.hasUpdateFailures());
        if (this.hasUpdateFailures()) {
            this.addDataFromUpgrade(model);
        }
        return model;
    }

    private void addDataFromUpgrade(Map<String, Object> model) {
        io.vavr.collection.List<UpdatePluginSettingsEntryResult> upgradeConfigResults = this.kssoUpdateManager.getUpdateFailures();
        model.putIfAbsent("upgradedUnblockedListWithErrorMessages", KssoUpdateManager.dataWithErrorMessages(upgradeConfigResults, KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST));
        model.putIfAbsent("unblockedListUpgradeErrors", KssoUpdateManager.onlyIpRestrictErrorMessagesCommaSeparated(upgradeConfigResults, KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST));
        model.putIfAbsent("upgradedBlockedListWithErrorMessages", KssoUpdateManager.dataWithErrorMessages(upgradeConfigResults, KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST));
        model.putIfAbsent("blockedListUpgradeErrors", KssoUpdateManager.onlyIpRestrictErrorMessagesCommaSeparated(upgradeConfigResults, KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST));
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation() {
        return io.vavr.collection.List.ofAll(this.apiTokenService.findAllTokens()).map(t -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenV570)t, this.userManager, this.apiTokenService)).asJava();
    }
}

