/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.utils.AuthorizationUtil;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasKerberosPreFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KerbConfManager kerbConfManager;
    private final ApiTokenService apiTokenService;
    private String[] products;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;

    @Inject
    public AtlasKerberosPreFilter(KerbConfManager kerbConfManager, ApiTokenService apiTokenService, HostAppFactory hostAppFactory, UserLookupService userLookupService) {
        this.kerbConfManager = kerbConfManager;
        this.apiTokenService = apiTokenService;
        this.hostApp = hostAppFactory.getInstance();
        this.userLookupService = userLookupService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this.isProductMatch()) {
            chain.doFilter(request, response);
            return;
        }
        if (this.hostApp.isScimRequest(req)) {
            chain.doFilter((ServletRequest)this.wrapScimAuthHeader(req), (ServletResponse)res);
            this.log.debug("Request to SCIM server. Avoid normal login");
            return;
        }
        if (this.kerbConfManager.isBasicAuthDisabled() && AuthorizationUtil.isBasicAuth(req) && !this.apiTokenService.requestHasApiToken(req) && !this.hostApp.isJiraCrowdRequest(req)) {
            this.log.debug("Blocking BasicAuth authentication request");
            this.sendError(res);
            return;
        }
        if (!this.kerbConfManager.isTraditionalLoginDisabled() || !this.hostApp.isPasswordLoginRequest(req)) {
            chain.doFilter(request, response);
        } else {
            List<Object> dirsAllowing = new ArrayList();
            try {
                dirsAllowing = this.userLookupService.getDirectoriesAllowingTraditionalLogin();
            }
            catch (RuntimeException e) {
                this.log.warn("Not able to search for directories: " + e.getMessage());
            }
            if (dirsAllowing.size() > 0 || this.kerbConfManager.getAllowTraditionalLoginGroups().size() > 0 || this.kerbConfManager.getDisallowTraditionalLoginGroups().size() > 0) {
                if (this.userLookupService.hasUserAccess(req) && this.userLookupService.isUserInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, this.kerbConfManager.getAllowTraditionalLoginGroups(), this.kerbConfManager.getDisallowTraditionalLoginGroups(), this.hostApp.getLoginRequestUsername(req))) {
                    chain.doFilter(request, response);
                } else if (!(this.kerbConfManager.isTraditionalLoginDisabledJSD() && !this.userLookupService.isUserInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, this.kerbConfManager.getAllowTraditionalLoginGroups(), this.kerbConfManager.getDisallowTraditionalLoginGroups(), this.hostApp.getLoginRequestUsername(req)) || this.userLookupService.hasUserAccess(req))) {
                    chain.doFilter(request, response);
                } else {
                    String errorPage = this.kerbConfManager.getTraditionalLoginDisabledMessage();
                    if (StringUtils.contains((String)this.kerbConfManager.getTraditionalLoginDisabledMessage(), (String)"%s%s")) {
                        errorPage = String.format(this.kerbConfManager.getTraditionalLoginDisabledMessage(), req.getContextPath(), this.hostApp.getLoginPage());
                    }
                    res.setContentType("text/html");
                    res.getWriter().print(errorPage);
                }
            } else if (!this.kerbConfManager.isTraditionalLoginDisabledJSD()) {
                if (this.userLookupService.hasUserAccess(req)) {
                    this.log.debug("Blocking request giving incorrect password because no rights to use passwords with roles");
                    res.setContentType("application/json");
                    res.getWriter().print("{\"loginSucceeded\":false,\"loginError\":false,\"communicationError\":false,\"elevatedSecurityCheckShown\":false,\"captchaFailure\":false,\"loginFailedByPermissions\":false,\"passwordResetRequired\":false}");
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                this.log.debug("Blocking request containing password parameter");
                this.sendError(res);
            }
        }
    }

    private boolean userInAllowedDirectoryOrGroup(HttpServletRequest req, List<Directory> dirsAllowing) {
        try {
            String username = this.hostApp.getLoginRequestUsername(req);
            List<UsernameSearchResult> usernameSearchResult = null;
            if (username != null) {
                usernameSearchResult = this.userLookupService.searchUserAccount(username, IdpConfiguration.UserNotFoundPolicy.REJECT, IdpConfiguration.UserLookupAttribute.USERNAME, false);
            }
            if (usernameSearchResult != null) {
                UsernameSearchResult userFound = null;
                for (UsernameSearchResult usernameSearchResult2 : usernameSearchResult) {
                    if (usernameSearchResult2 == null || usernameSearchResult2.getUserProfile() == null) continue;
                    userFound = usernameSearchResult2;
                }
                if (userFound != null) {
                    Directory usernameDirectory = userFound.getDirectory();
                    for (Directory dir : dirsAllowing) {
                        if (!dir.getId().equals(usernameDirectory.getId())) continue;
                        return true;
                    }
                    for (String group : this.kerbConfManager.getAllowTraditionalLoginGroups()) {
                        if (!this.hostApp.isUserInGroup(username, group)) continue;
                        return true;
                    }
                    if (this.kerbConfManager.getDisallowTraditionalLoginGroups().size() > 0) {
                        boolean bl;
                        boolean bl2 = true;
                        for (String group : this.kerbConfManager.getDisallowTraditionalLoginGroups()) {
                            if (!this.hostApp.isUserInGroup(username, group)) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
            }
        }
        catch (RuntimeException r) {
            this.log.error(ErrorUtils.createErrorMessage("KSSO-KILKDR1VEI", "Problem when searching for user in directory: " + r));
        }
        return false;
    }

    private void sendError(HttpServletResponse res) throws IOException {
        res.sendError(403, "Username and password authentication has been disabled by the administrator.");
    }

    public void destroy() {
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    private HttpServletRequest wrapScimAuthHeader(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){
            private Set<String> headerNameSet;

            public Enumeration<String> getHeaderNames() {
                if (this.headerNameSet == null) {
                    this.headerNameSet = new HashSet<String>();
                    Enumeration wrappedHeaderNames = super.getHeaderNames();
                    while (wrappedHeaderNames.hasMoreElements()) {
                        String headerName = (String)wrappedHeaderNames.nextElement();
                        if ("Authorization".equalsIgnoreCase(headerName)) {
                            this.headerNameSet.add("ScimAuthorization");
                            continue;
                        }
                        this.headerNameSet.add(headerName);
                    }
                }
                return Collections.enumeration(this.headerNameSet);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return Collections.emptyEnumeration();
                }
                if ("ScimAuthorization".equalsIgnoreCase(name)) {
                    return super.getHeaders("Authorization");
                }
                return super.getHeaders(name);
            }

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return null;
                }
                if ("ScimAuthorization".equalsIgnoreCase(name)) {
                    return super.getHeader("Authorization");
                }
                return super.getHeader(name);
            }
        };
    }
}

