var traditionalLoginIsDisabled = true;
var traditionalLoginDisabledHasRun = false;

window.addEventListener("load", function () {
  disableLoginfields();

  if ("MutationObserver" in window) {
    var obs = new MutationObserver(function (mutations, observer) {
      console.log("Observed mutation in disabling traditional login");
      disableLoginfields();
    });

    obs.observe(document.body, {childList: true, subtree: true});
  }
});

function disableLoginfields() {
  if (traditionalLoginDisabledHasRun) {
    console.log("Disabling of traditional login has already been done.");
    return;
  }
  console.log("Starting to disable traditional login...");
  var usernameInput = document.querySelector(
      "input[name=os_username], input[name=j_username], form[name=loginform] input[name=username]"
  );

  if (usernameInput !== null) {
    loginform = usernameInput.form;

    var children = loginform.children;
    for (var i = 0; i < children.length; i++) {
      var child = children[i];
      child.style.display = "none";

      var inputchildren = child.children;
      for (var j = 0; j < inputchildren.length; j++) {
        var inputchild = inputchildren[j];
        inputchild.disabled = true;
      }

      console.log("Child:" + child.id);
    }

    var username_password_disabled_para = document.createElement("p");
    username_password_disabled_para.setAttribute(
        "id",
        "username_password_disabled_text"
    );

    var unknown_username_text = document.createElement("p");
    unknown_username_text.appendChild(
        document.createTextNode("The username you typed was unknown")
    );

    unknown_username_text.setAttribute("id", "unknown_username_text");
    unknown_username_text.style.display = "none";

    var disabled_text = document.createTextNode(
        "Username / password login is disabled by your administrator"
    );

    var back = document.createElement("button");
    var t = document.createTextNode("Back");
    back.appendChild(t);
    back.setAttribute("id", "disabled_login_back_button");
    back.setAttribute("class", "aui-button aui-button-primary");
    back.style.display = "none";

    username_password_disabled_para.appendChild(unknown_username_text);
    username_password_disabled_para.appendChild(disabled_text);
    username_password_disabled_para.appendChild(back);
    loginform.parentElement.appendChild(username_password_disabled_para);

    console.log("Finished to disable traditional login.");
    traditionalLoginDisabledHasRun = true;
  }
}
