/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.asn1;

import java.io.IOException;
import shaded.org.bouncycastle.asn1.DERObject;
import shaded.org.bouncycastle.asn1.DEROutputStream;
import shaded.org.bouncycastle.util.Arrays;

public class DERUnknownTag
extends DERObject {
    private boolean isConstructed;
    private int tag;
    private byte[] data;

    public DERUnknownTag(int n, byte[] byArray) {
        this(false, n, byArray);
    }

    public DERUnknownTag(boolean bl, int n, byte[] byArray) {
        this.isConstructed = bl;
        this.tag = n;
        this.data = byArray;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(this.isConstructed ? 32 : 0, this.tag, this.data);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERUnknownTag)) {
            return false;
        }
        DERUnknownTag dERUnknownTag = (DERUnknownTag)object;
        return this.isConstructed == dERUnknownTag.isConstructed && this.tag == dERUnknownTag.tag && Arrays.areEqual((byte[])this.data, (byte[])dERUnknownTag.data);
    }

    public int hashCode() {
        return (this.isConstructed ? -1 : 0) ^ this.tag ^ Arrays.hashCode((byte[])this.data);
    }
}

