/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.serberuhs.filter;

import java.io.File;
import javax.servlet.FilterConfig;
import org.simplericity.serberuhs.filter.KerberosFilterConfiguration;

public class DefaultFilterConfiguration
implements KerberosFilterConfiguration {
    private static final String ENABLED_PROP = "enabled";
    private static final String KEYTAB_FILE_PROP = "keytabFile";
    private static final String PRINCIPAL_PROP = "principal";
    private static final String PASSWORD_PROP = "password";
    private static final String FALLBACK_LOGIN_PROP = "fallbackLogin";
    private final boolean enabled;
    private final File keytabFile;
    private final String principal;
    private final String password;
    private final FilterConfig filterConfig;

    public DefaultFilterConfiguration(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.verifyConfigurationPresent(filterConfig);
        this.keytabFile = new File(filterConfig.getInitParameter(KEYTAB_FILE_PROP));
        if (!this.keytabFile.exists()) {
            throw new IllegalArgumentException("keytabFile not found " + this.keytabFile.getAbsolutePath());
        }
        this.principal = filterConfig.getInitParameter(PRINCIPAL_PROP);
        this.password = filterConfig.getInitParameter(PASSWORD_PROP);
        this.enabled = !"false".equals(filterConfig.getInitParameter(ENABLED_PROP));
    }

    private void verifyConfigurationPresent(FilterConfig filterConfig) {
        String[] props;
        for (String prop : props = new String[]{KEYTAB_FILE_PROP, PRINCIPAL_PROP, PASSWORD_PROP}) {
            if (filterConfig.getInitParameter(prop) != null) continue;
            throw new IllegalArgumentException("Filter configuration parameter '" + prop + "' is required");
        }
    }

    public File getKeytabFile() {
        return this.keytabFile;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFallbackLoginPath() {
        return this.filterConfig.getInitParameter(FALLBACK_LOGIN_PROP);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

