/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.serberuhs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.simplericity.serberuhs.SpNegoResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.commons.codec.binary.Base64;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Sequence;
import shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import shaded.org.bouncycastle.asn1.DERInputStream;
import shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import shaded.org.bouncycastle.asn1.DERUnknownTag;

public class SpNego {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SpNegoResult result;
    private String authorizedPrincipal;
    private Exception exception;
    private static final byte[] NTLMSSP_PREFIX = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static final Set<String> KERBEROS_OIDS = new HashSet<String>(Arrays.asList("1.2.840.113554.1.2.2", "1.2.840.48018.1.2.2"));
    private static final String NTLM_OID = "1.3.6.1.4.1.311.2.2.10";
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String IAKERB_OID = "1.3.6.1.5.2.5";
    private byte[] kerberosToken;

    public void negotiate(Subject subject, HttpServletRequest request, HttpServletResponse response) {
        String atz = request.getHeader("Authorization");
        if (atz == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authorization header is missing, initiating Negotiate");
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            this.result = SpNegoResult.MISSING_AUTHORIZATION_HEADER;
            return;
        }
        if (atz.startsWith("Basic ")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client sent a Basic token instead of SPNEGO / Kerberos: " + atz);
            }
            this.result = SpNegoResult.WRONG_TOKEN_BASIC;
            return;
        }
        if (!this.isNegotiate(atz)) {
            this.log.debug("Client sent a WWW-Authenticate header that does not start with 'Negotiate ': " + atz);
            this.result = SpNegoResult.WRONG_TOKEN_NOT_NEGOTIATE;
        } else if (this.isNtlm(atz)) {
            this.log.debug("Client sent an NTLM token instead of SPNEGO / Kerberos: " + atz);
            this.result = SpNegoResult.WRONG_TOKEN_NTLM;
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authorization header is: " + atz);
            }
            String encodedToken = atz.substring("Negotiate ".length());
            byte[] token = Base64.decodeBase64(((Charset)Charset.availableCharsets().get("utf-8")).encode(encodedToken).array());
            try {
                this.kerberosToken = this.getKerberosToken(token);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed parsing token", (Throwable)e);
                }
                this.result = SpNegoResult.FAILED_PARSING_TOKEN;
                this.exception = e;
                return;
            }
            catch (NtlmTokenException e) {
                this.result = SpNegoResult.WRONG_TOKEN_NTLM;
                return;
            }
            final String servicePrincipal = subject.getPrincipals().iterator().next().getName();
            Subject.doAs(subject, new PrivilegedAction(){

                public Object run() {
                    try {
                        GSSManager manager = GSSManager.getInstance();
                        GSSName gssName = manager.createName(servicePrincipal, null);
                        GSSCredential serverGSSCreds = manager.createCredential(gssName, Integer.MAX_VALUE, new Oid(SpNego.KERBEROS_OID), 2);
                        GSSContext serverGSSContext = manager.createContext(serverGSSCreds);
                        serverGSSContext.acceptSecContext(SpNego.this.kerberosToken, 0, SpNego.this.kerberosToken.length);
                        if (serverGSSContext.isEstablished()) {
                            SpNego.this.log.info("Logged in " + serverGSSContext.getSrcName());
                            SpNego.this.authorizedPrincipal = serverGSSContext.getSrcName().toString();
                        }
                        SpNego.this.result = SpNegoResult.AUTHORIZED;
                    }
                    catch (GSSException e) {
                        if (SpNego.this.log.isDebugEnabled()) {
                            SpNego.this.log.debug("SPNEGO authorization failed with a GSSException", (Throwable)e);
                        }
                        SpNego.this.result = SpNegoResult.AUTHORIZATION_FAILED;
                        SpNego.this.exception = e;
                    }
                    return null;
                }
            });
        }
    }

    private boolean isNegotiate(String atz) {
        return atz != null && atz.startsWith("Negotiate ");
    }

    public byte[] getKerberosToken(byte[] token) throws IOException, NtlmTokenException {
        if (this.isNtlm(token)) {
            throw new DirectNtlmTokenException();
        }
        byte[] kerbtoken = null;
        DERInputStream der = new DERInputStream(new ByteArrayInputStream(token));
        DERUnknownTag constructed = (DERUnknownTag)der.readObject();
        if (constructed.getTag() != 96) {
            throw new IOException("Malformed token did not start with 0x60");
        }
        ByteArrayInputStream tokenStream = new ByteArrayInputStream(constructed.getData());
        der = new DERInputStream(tokenStream);
        DERObjectIdentifier objectIdentifier = (DERObjectIdentifier)der.readObject();
        if (KERBEROS_OIDS.contains(objectIdentifier.getId())) {
            kerbtoken = token;
        } else {
            ASN1Sequence sequence = ASN1Sequence.getInstance((ASN1TaggedObject)der.readObject(), true);
            Enumeration fields = sequence.getObjects();
            while (fields.hasMoreElements()) {
                ASN1TaggedObject tags = (ASN1TaggedObject)fields.nextElement();
                if (tags.getTagNo() == 0) {
                    ASN1Sequence mechTypes = ASN1Sequence.getInstance(tags, true);
                    if (this.hasKerberos(mechTypes.getObjects())) continue;
                    if (this.hasOid(mechTypes.getObjects(), NTLM_OID)) {
                        throw new NtlmTokenException();
                    }
                    if (this.hasOid(mechTypes.getObjects(), IAKERB_OID)) {
                        throw new IaKerbTokenException();
                    }
                    throw new NoKerberosMechException("No kerberos support found");
                }
                if (tags.getTagNo() != 2) continue;
                ASN1OctetString mechanismToken = ASN1OctetString.getInstance(tags, true);
                kerbtoken = mechanismToken.getOctets();
            }
        }
        if (this.isNtlm(kerbtoken)) {
            throw new NtlmTokenException();
        }
        if (kerbtoken != null && kerbtoken[0] != 96 && kerbtoken[0] == 110) {
            byte[] encodedOid = new DERObjectIdentifier(KERBEROS_OID).getEncoded();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(96);
            this.writeDERLength(bos, encodedOid.length + 2 + kerbtoken.length);
            bos.write(encodedOid);
            bos.write(1);
            bos.write(0);
            bos.write(kerbtoken);
            kerbtoken = bos.toByteArray();
        }
        return kerbtoken;
    }

    void writeDERLength(OutputStream out, int length) throws IOException {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            out.write((byte)(size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                out.write((byte)(length >> i));
            }
        } else {
            out.write((byte)length);
        }
    }

    private boolean hasOid(Enumeration mechTypes, String ntlmOid) {
        while (mechTypes.hasMoreElements()) {
            if (!ntlmOid.equals(mechTypes.nextElement().toString())) continue;
            return true;
        }
        return false;
    }

    private boolean hasKerberos(Enumeration mechTypes) {
        while (mechTypes.hasMoreElements()) {
            if (!KERBEROS_OIDS.contains(mechTypes.nextElement().toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isNtlm(String atz) {
        return this.isNtlm(Base64.decodeBase64(((Charset)Charset.availableCharsets().get("utf-8")).encode(atz.substring("Negotiate ".length())).array()));
    }

    private boolean isNtlm(byte[] token) {
        if (token.length < NTLMSSP_PREFIX.length) {
            return false;
        }
        for (int i = 0; i < NTLMSSP_PREFIX.length; ++i) {
            if (token[i] == NTLMSSP_PREFIX[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getKerberosToken() {
        return this.kerberosToken;
    }

    public SpNegoResult getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getAuthorizedPrincipal() {
        return this.authorizedPrincipal;
    }

    public static class NoKerberosMechException
    extends RuntimeException {
        public NoKerberosMechException(String s) {
            super(s);
        }
    }

    public static class DirectNtlmTokenException
    extends RuntimeException {
    }

    public static class IaKerbTokenException
    extends RuntimeException {
    }

    public static class NtlmTokenException
    extends RuntimeException {
    }
}

