/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.serberuhs;

import java.io.IOException;
import shaded.org.bouncycastle.asn1.ASN1InputStream;
import shaded.org.bouncycastle.asn1.DERApplicationSpecific;
import shaded.org.bouncycastle.asn1.DERBitString;
import shaded.org.bouncycastle.asn1.DERGeneralString;
import shaded.org.bouncycastle.asn1.DERInteger;
import shaded.org.bouncycastle.asn1.DERObject;
import shaded.org.bouncycastle.asn1.DERSequence;
import shaded.org.bouncycastle.asn1.DERTaggedObject;

public class DecodedKerberosToken {
    private String realm;
    private int encType;
    private int kvno;
    private String service;
    private String host;

    public static DecodedKerberosToken fromToken(byte[] kerberosToken) throws Exception {
        DecodedKerberosToken decoded = new DecodedKerberosToken();
        decoded.parse(kerberosToken);
        return decoded;
    }

    public void parse(byte[] kerberosToken) throws IOException {
        ASN1InputStream is = new ASN1InputStream(kerberosToken);
        DERApplicationSpecific derObject = (DERApplicationSpecific)is.readObject();
        ASN1InputStream is2 = new ASN1InputStream(derObject.getContents());
        DERObject derObject2 = is2.readObject();
        int readLowByte = is2.read() & 0xFF;
        int readHighByte = is2.read() & 0xFF;
        int read = (readHighByte << 8) + readLowByte;
        DERApplicationSpecific derObject3 = (DERApplicationSpecific)is2.readObject();
        ASN1InputStream is3 = new ASN1InputStream(derObject3.getContents());
        DERSequence derObject4 = (DERSequence)is3.readObject();
        for (int i = 0; i < derObject4.size(); ++i) {
            DERTaggedObject taggedObject = (DERTaggedObject)derObject4.getObjectAt(i);
            if (taggedObject.getTagNo() == 0) {
                DERInteger protocolVersionNumber = (DERInteger)taggedObject.getObject();
                continue;
            }
            if (taggedObject.getTagNo() == 1) {
                DERInteger messageType = (DERInteger)taggedObject.getObject();
                continue;
            }
            if (taggedObject.getTagNo() == 2) {
                DERBitString options = (DERBitString)taggedObject.getObject();
                continue;
            }
            if (taggedObject.getTagNo() == 3) {
                DERApplicationSpecific unknown = (DERApplicationSpecific)taggedObject.getObject();
                DERSequence ticketPart = (DERSequence)new ASN1InputStream(unknown.getContents()).readObject();
                this.parseTicket(ticketPart);
                continue;
            }
            if (taggedObject.getTagNo() != 4) continue;
            DERSequence authenticatorEncPart = (DERSequence)taggedObject.getObject();
        }
    }

    private void parseTicket(DERSequence namePart) {
        for (int i = 0; i < namePart.size(); ++i) {
            DERTaggedObject taggedObject = (DERTaggedObject)namePart.getObjectAt(i);
            if (taggedObject.getTagNo() == 0) {
                DERInteger ticketVersionNumber = (DERInteger)taggedObject.getObject();
                continue;
            }
            if (taggedObject.getTagNo() == 1) {
                DERGeneralString realmPart = (DERGeneralString)taggedObject.getObject();
                this.realm = realmPart.getString();
                continue;
            }
            if (taggedObject.getTagNo() == 2) {
                DERSequence hostPart = (DERSequence)taggedObject.getObject();
                this.parsePrincipalName(hostPart);
                continue;
            }
            if (taggedObject.getTagNo() != 3) continue;
            DERSequence encPart = (DERSequence)taggedObject.getObject();
            this.parseEncPart(encPart);
        }
    }

    private void parseEncPart(DERSequence encPart) {
        for (int i = 0; i < encPart.size(); ++i) {
            DERTaggedObject taggedObject = (DERTaggedObject)encPart.getObjectAt(i);
            if (taggedObject.getTagNo() == 0) {
                DERInteger encType = (DERInteger)taggedObject.getObject();
                this.encType = encType.getValue().intValue();
                continue;
            }
            if (taggedObject.getTagNo() != 1) continue;
            DERInteger kvno = (DERInteger)taggedObject.getObject();
            this.kvno = kvno.getValue().intValue();
        }
    }

    private void parsePrincipalName(DERSequence spnPart) {
        for (int i = 0; i < spnPart.size(); ++i) {
            DERTaggedObject taggedObject = (DERTaggedObject)spnPart.getObjectAt(i);
            if (taggedObject.getTagNo() == 0) {
                DERInteger nameType = (DERInteger)taggedObject.getObject();
                continue;
            }
            if (taggedObject.getTagNo() != 1) continue;
            DERSequence hostPart = (DERSequence)taggedObject.getObject();
            this.parseHostPart(hostPart);
        }
    }

    private void parseHostPart(DERSequence hostPart) {
        DERGeneralString service = (DERGeneralString)hostPart.getObjectAt(0);
        this.service = service.getString();
        DERGeneralString host = (DERGeneralString)hostPart.getObjectAt(1);
        this.host = host.getString();
    }

    public String getRealm() {
        return this.realm;
    }

    public int getEncType() {
        return this.encType;
    }

    public int getKvno() {
        return this.kvno;
    }

    public String getService() {
        return this.service;
    }

    public String getHost() {
        return this.host;
    }
}

