/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.messaging.impl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kantega.shaded.com.google.common.base.Function;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureValidationConfigurationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateSignatureValidationParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSignatureValidationParametersHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup<MessageContext, SecurityParametersContext>(SecurityParametersContext.class, true);
    @NonnullAfterInit
    private Function<MessageContext, List<SignatureValidationConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private SignatureValidationParametersResolver resolver;

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.securityParametersContextLookupStrategy = Constraint.isNotNull(strategy, "SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<SignatureValidationConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.configurationLookupStrategy = Constraint.isNotNull(strategy, "SignatureValidationConfiguration lookup strategy cannot be null");
    }

    public void setSignatureValidationParametersResolver(@Nonnull SignatureValidationParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.resolver = Constraint.isNotNull(newResolver, "SignatureValidationParametersResolver cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureValidationParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<MessageContext, List<SignatureValidationConfiguration>>(){

                @Override
                public List<SignatureValidationConfiguration> apply(MessageContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalSignatureValidationConfiguration());
                }
            };
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.log.debug("{} Resolving SignatureValidationParameters for request", (Object)this.getLogPrefix());
        List<SignatureValidationConfiguration> configs = this.configurationLookupStrategy.apply(messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No SignatureValidationConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SignatureValidationConfiguration returned by lookup strategy");
        }
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (paramsCtx == null) {
            this.log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("SecurityParametersContext returned by lookup strategy");
        }
        try {
            SignatureValidationParameters params = (SignatureValidationParameters)this.resolver.resolveSingle(new CriteriaSet(new SignatureValidationConfigurationCriterion(configs)));
            paramsCtx.setSignatureValidationParameters(params);
            this.log.debug("{} {} SignatureValidationParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving SignatureValidationParameters", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Error resolving SignatureValidationParameters");
        }
    }
}

