/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class ReplayCache
extends AbstractIdentifiableInitializableComponent {
    private final Logger log = LoggerFactory.getLogger(ReplayCache.class);
    @NonnullAfterInit
    private StorageService storage;
    @NonnullAfterInit
    private StringDigester digester;
    private boolean strict;

    @NonnullAfterInit
    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull StorageService storageService) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.storage = Constraint.isNotNull(storageService, "StorageService cannot be null");
        StorageCapabilities caps = this.storage.getCapabilities();
        if (caps instanceof StorageCapabilitiesEx) {
            Constraint.isTrue(((StorageCapabilitiesEx)caps).isServerSide(), "StorageService cannot be client-side");
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.strict = flag;
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        if (this.storage == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        try {
            this.digester = new StringDigester("SHA", StringDigester.OutputFormat.HEX_LOWER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ComponentInitializationException(e);
        }
    }

    public synchronized boolean check(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String s, long expires) {
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("Context '{}' too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return false;
        }
        String key = s.length() > caps.getKeySize() ? this.digester.apply(s) : s;
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("Value '{}' was not a replay, adding to cache with expiration time {}", (Object)s, (Object)expires);
                this.storage.create(context, key, "x", expires);
                return true;
            }
            this.log.debug("Replay of value '{}' detected in cache, expires at {}", (Object)s, (Object)entry.getExpiration());
            return false;
        }
        catch (IOException e) {
            this.log.error("Exception reading/writing to storage service, returning {}", (Object)(this.strict ? "failure" : "success"), (Object)e);
            return !this.strict;
        }
    }
}

