/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.security;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kantega.shaded.com.google.common.base.Function;
import kantega.shaded.com.google.common.base.Functions;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.soap.client.security.SOAPClientSecurityContext;

public class SOAPClientSecurityProfileIdLookupFunction
implements ContextDataLookupFunction<MessageContext, String> {
    private Function<MessageContext, SOAPClientSecurityContext> soapContextLookup = Functions.compose(new ChildContextLookup(SOAPClientSecurityContext.class), new RecursiveTypedParentContextLookup(InOutOperationContext.class));

    public void setSOAPClientSecurityContextLookup(@Nonnull Function<MessageContext, SOAPClientSecurityContext> lookup) {
        this.soapContextLookup = Constraint.isNotNull(lookup, "SOAPClientSecurityContext lookup function was null");
    }

    @Override
    public String apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        SOAPClientSecurityContext context = this.soapContextLookup.apply(messageContext);
        if (context != null) {
            return context.getSecurityConfigurationProfileId();
        }
        return null;
    }
}

