/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.messaging;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kantega.shaded.com.google.common.base.Function;
import kantega.shaded.com.google.common.base.Functions;
import kantega.shaded.com.google.common.base.Predicates;
import kantega.shaded.com.google.common.collect.Maps;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.soap.client.SOAPClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPClientPipelineNameMappingFunction<T>
implements Function<MessageContext, T> {
    private Logger log = LoggerFactory.getLogger(SOAPClientPipelineNameMappingFunction.class);
    @Nonnull
    private Function<MessageContext, SOAPClientContext> soapClientContextLookup;
    @Nonnull
    private Map<String, Function<MessageContext, T>> delegateMap;

    public SOAPClientPipelineNameMappingFunction(@Nonnull @ParameterName(name="mappings") Map<String, Function<MessageContext, T>> mappings) {
        this(mappings, null);
    }

    public SOAPClientPipelineNameMappingFunction(@Nonnull @ParameterName(name="mappings") Map<String, Function<MessageContext, T>> mappings, @Nullable @ParameterName(name="lookupStrategy") ContextDataLookupFunction<MessageContext, SOAPClientContext> lookupStrategy) {
        Constraint.isNotNull(mappings, "Delegate mappings may not be null");
        this.delegateMap = new HashMap<String, Function<MessageContext, T>>(Maps.filterKeys(Maps.filterValues(mappings, Predicates.notNull()), Predicates.notNull()));
        this.soapClientContextLookup = lookupStrategy != null ? lookupStrategy : Functions.compose(new ChildContextLookup(SOAPClientContext.class), new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    }

    @Override
    public T apply(@Nullable MessageContext input) {
        if (input == null) {
            return null;
        }
        SOAPClientContext clientContext = this.soapClientContextLookup.apply(input);
        if (clientContext != null && clientContext.getPipelineName() != null) {
            this.log.debug("Resolved SOAP client pipeline name: {}", (Object)clientContext.getPipelineName());
            Function<MessageContext, T> delegate = this.delegateMap.get(clientContext.getPipelineName());
            this.log.debug("Resolved delegate function: {}", (Object)(delegate != null ? delegate.getClass().getName() : "null"));
            if (delegate != null) {
                return delegate.apply(input);
            }
        }
        this.log.debug("No delegate function could be resolved, returning null");
        return null;
    }
}

