/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import javax.annotation.Nonnull;
import kantega.shaded.com.google.common.base.Function;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;

public class ExtractProxiedRequestersHandler
extends AbstractMessageHandler {
    @Nonnull
    private Function<MessageContext, ProxiedRequesterContext> proxiedContextCreationStrategy = new ChildContextLookup<MessageContext, ProxiedRequesterContext>(ProxiedRequesterContext.class, true);

    public void setProxiedRequesterContextCreationStrategy(@Nonnull Function<MessageContext, ProxiedRequesterContext> strategy) {
        this.proxiedContextCreationStrategy = Constraint.isNotNull(strategy, "ProxiedRequesterContext creation strategy cannot be null");
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Object request = messageContext.getMessage();
        if (request == null) {
            throw new MessageHandlerException("Message not found");
        }
        if (!(request instanceof AuthnRequest)) {
            throw new MessageHandlerException("Message was not an AuthnRequest");
        }
        Scoping scoping = ((AuthnRequest)request).getScoping();
        if (scoping != null && !scoping.getRequesterIDs().isEmpty()) {
            ProxiedRequesterContext proxyContext = this.proxiedContextCreationStrategy.apply(messageContext);
            if (proxyContext == null) {
                throw new MessageHandlerException("Failed to create/locate ProxiedRequesterContext");
            }
            for (RequesterID id : scoping.getRequesterIDs()) {
                if (id == null || id.getRequesterID() == null) continue;
                proxyContext.getRequesters().add(id.getRequesterID());
            }
        }
    }
}

