/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kantega.shaded.com.google.common.base.Function;
import kantega.shaded.com.google.common.base.Functions;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.ext.reqattr.RequestedAttributes;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLAddAttributeConsumingServiceHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLAddAttributeConsumingServiceHandler.class);
    @Nonnull
    private Function<MessageContext, SAMLMetadataContext> metadataContextLookupStrategy = Functions.compose(new ChildContextLookup(SAMLMetadataContext.class), new ChildContextLookup(SAMLPeerEntityContext.class));
    @Nonnull
    private Function<MessageContext, AuthnRequest> authnRequestLookupStrategy = new AuthnRequestLookup();
    @Nullable
    private Integer index;
    @Nullable
    private List<RequestedAttribute> requestedAttributes;

    public void setMetadataContextLookupStrategy(@Nonnull Function<MessageContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = Constraint.isNotNull(strategy, "SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setIndexLookupStrategy(@Nullable Function<MessageContext, AuthnRequest> strategy) {
        this.authnRequestLookupStrategy = Constraint.isNotNull(strategy, "AuthnRequest lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        AuthnRequest authn = this.authnRequestLookupStrategy.apply(messageContext);
        if (authn != null) {
            this.index = authn.getAttributeConsumingServiceIndex();
            this.requestedAttributes = this.getRequestedAttributes(authn);
            if (this.index != null && this.requestedAttributes != null && !this.requestedAttributes.isEmpty()) {
                this.log.info("{} AuthnRequest from {} contained a AttributeConsumingServiceIndex and RequestedAttributes; ignoring the RequestedAttributes.", (Object)this.getLogPrefix(), (Object)authn.getProviderName());
                this.requestedAttributes = null;
            }
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLMetadataContext metadataContext = this.metadataContextLookupStrategy.apply(messageContext);
        if (metadataContext == null) {
            this.log.debug("{} No metadata context found, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (!(metadataContext.getRoleDescriptor() instanceof SPSSODescriptor)) {
            this.log.debug("{} Metadata context did not contain an SPSSODescriptor, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        SPSSODescriptor ssoDescriptor = (SPSSODescriptor)metadataContext.getRoleDescriptor();
        AttributeConsumingService acs = null;
        if (null != this.index) {
            this.log.debug("{} Request specified AttributeConsumingService index {}", (Object)this.getLogPrefix(), (Object)this.index);
            for (AttributeConsumingService acsEntry : ssoDescriptor.getAttributeConsumingServices()) {
                if (this.index.intValue() != acsEntry.getIndex()) continue;
                acs = acsEntry;
                break;
            }
        }
        if (null == acs) {
            if (this.requestedAttributes != null && !this.requestedAttributes.isEmpty()) {
                this.log.debug("{} Creating AttributeConsumingService with requested Attributes {}", (Object)this.getLogPrefix(), this.requestedAttributes);
                acs = this.attributeConsumingServiceFromRequestedAttributes();
            } else {
                this.log.debug("{} Selecting default AttributeConsumingService, if any", (Object)this.getLogPrefix());
                acs = ssoDescriptor.getDefaultAttributeConsumingService();
            }
        }
        if (null != acs) {
            this.log.debug("{} Selected AttributeConsumingService with index {}", (Object)this.getLogPrefix(), (Object)acs.getIndex());
            metadataContext.getSubcontext(AttributeConsumingServiceContext.class, true).setAttributeConsumingService(acs);
        } else {
            this.log.debug("{} No AttributeConsumingService selected", (Object)this.getLogPrefix());
        }
    }

    private AttributeConsumingService attributeConsumingServiceFromRequestedAttributes() throws MessageHandlerException {
        AttributeConsumingService newAcs = (AttributeConsumingService)XMLObjectSupport.buildXMLObject(AttributeConsumingService.DEFAULT_ELEMENT_NAME);
        for (RequestedAttribute attribute : this.requestedAttributes) {
            try {
                newAcs.getRequestAttributes().add(XMLObjectSupport.cloneXMLObject(attribute, XMLObjectSupport.CloneOutputOption.DropDOM));
            }
            catch (MarshallingException | UnmarshallingException e) {
                this.log.warn("{} Error cloning requested Attributes", (Object)this.getLogPrefix(), (Object)e);
                throw new MessageHandlerException(e);
            }
        }
        return newAcs;
    }

    private List<RequestedAttribute> getRequestedAttributes(AuthnRequest authn) {
        Extensions extensions = authn.getExtensions();
        if (extensions == null) {
            return null;
        }
        List<XMLObject> bindings = extensions.getUnknownXMLObjects(RequestedAttributes.DEFAULT_ELEMENT_NAME);
        if (bindings == null || bindings.isEmpty()) {
            return null;
        }
        return ((RequestedAttributes)bindings.get(0)).getRequestedAttributes();
    }

    private class AuthnRequestLookup
    implements Function<MessageContext, AuthnRequest> {
        private AuthnRequestLookup() {
        }

        @Override
        public AuthnRequest apply(@Nullable MessageContext input) {
            Object message;
            if (input != null && (message = input.getMessage()) != null && message instanceof AuthnRequest) {
                return (AuthnRequest)message;
            }
            return null;
        }
    }
}

