/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder.httpclient;

import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.httpclient.AbstractHttpClientRequestMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class BaseHttpClientRequestXMLMessageEncoder<MessageType extends XMLObject>
extends AbstractHttpClientRequestMessageEncoder<MessageType> {
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    private final Logger log = LoggerFactory.getLogger(BaseHttpClientRequestXMLMessageEncoder.class);

    @Override
    public void encode() throws MessageEncodingException {
        if (this.log.isDebugEnabled() && this.getMessageContext().getMessage() != null) {
            this.log.debug("Beginning encode of message of type: {}", (Object)((XMLObject)this.getMessageContext().getMessage()).getClass().getName());
        }
        super.encode();
        this.logEncodedMessage();
        this.log.debug("Successfully encoded message.");
    }

    protected void logEncodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            XMLObject message = this.getMessageToLog();
            if (message == null) {
                this.log.warn("Encoded message was null, nothing to log");
                return;
            }
            try {
                Element dom = XMLObjectSupport.marshall(message);
                this.protocolMessageLog.debug("\n" + SerializeSupport.prettyPrintXML(dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            }
        }
    }

    protected XMLObject getMessageToLog() {
        return (XMLObject)this.getMessageContext().getMessage();
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        this.log.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall(message);
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling message", (Throwable)e);
            throw new MessageEncodingException("Error marshalling message", e);
        }
    }
}

