/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.AbstractSamlValidationResult;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;

abstract class AbstractSamlValidator {
    final ServiceProviderSpi serviceProviderSpi;

    AbstractSamlValidator(ServiceProviderSpi serviceProviderSpi) {
        this.serviceProviderSpi = serviceProviderSpi;
    }

    void validateStatus(Status status, AbstractSamlValidationResult result) {
        if (status == null) {
            result.addResult(ResultType.MISSING_STATUS);
        } else if (status.getStatusCode() == null) {
            result.addResult(ResultType.MISSING_STATUS_CODE);
        } else if (status.getStatusCode().getValue() == null) {
            result.addResult(ResultType.MISSING_STATUS_CODE_VALUE);
        } else if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(status.getStatusCode().getValue())) {
            result.addResult(ResultType.STATUS_CODE_NOT_SUCCESS, Collections.singletonMap("status", status));
        }
    }

    boolean isOnOrAfter(DateTime now, DateTime notOnOrAfter) {
        return now.isEqual(notOnOrAfter.toInstant()) || now.isAfter(notOnOrAfter.toInstant());
    }

    boolean validateNotOnOrAfter(DateTime notOnOrAfter, DateTime now, AbstractSamlValidationResult result, ResultType missingElementCode, ResultType isOnOrAfterCode) {
        if (notOnOrAfter == null) {
            result.addResult(missingElementCode);
            return false;
        }
        if (this.isOnOrAfter(now, notOnOrAfter)) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("now", now);
            model.put("notOnOrAfter", notOnOrAfter);
            result.addResult(isOnOrAfterCode, model);
            return false;
        }
        return true;
    }

    void validateSignature(SignableSAMLObject signableSAMLObject, AbstractSamlValidationResult result, ResultType missingSignatureCode, ResultType unknownCertCode, ResultType failedValidationCode) {
        Signature signature = signableSAMLObject.getSignature();
        if (signature != null) {
            List<Credential> identityProviderCredentials = this.serviceProviderSpi.getIdentityProviderCredentials(signature);
            if (identityProviderCredentials.isEmpty()) {
                Optional<X509Certificate> cert = this.findX509Cert(signature);
                if (cert.isPresent()) {
                    result.addResult(unknownCertCode, Collections.singletonMap("cert", cert.get()));
                } else {
                    result.addResult(unknownCertCode);
                }
                return;
            }
            try {
                SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
                profileValidator.validate(signature);
            }
            catch (SignatureException e) {
                result.addResult(failedValidationCode);
                return;
            }
            if (!this.validateSignature(signature, identityProviderCredentials)) {
                result.addResult(failedValidationCode);
            }
        } else if (missingSignatureCode != null) {
            result.addResult(missingSignatureCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateSignature(Signature signature, List<Credential> identityProviderCredentials) {
        ClassLoader oldCcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            for (Credential credential : identityProviderCredentials) {
                try {
                    SignatureValidator.validate(signature, credential);
                    boolean bl = true;
                    return bl;
                }
                catch (SignatureException signatureException) {
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCcl);
        }
    }

    private Optional<X509Certificate> findX509Cert(Signature signature) {
        X509Data x509Data;
        if (signature.getKeyInfo() != null && signature.getKeyInfo() != null && !signature.getKeyInfo().getX509Datas().isEmpty() && !(x509Data = signature.getKeyInfo().getX509Datas().get(0)).getX509Certificates().isEmpty()) {
            return Optional.of(x509Data.getX509Certificates().get(0));
        }
        return Optional.empty();
    }

    protected void validateDestination(SamlLogoutValidationResult result, String destination, String expectedDestination, ResultType missingValueCode, ResultType invalidValueCode) {
        if (destination == null || destination.isEmpty()) {
            result.addResult(missingValueCode);
        } else if (!destination.equals(expectedDestination)) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("destination", destination);
            model.put("expectedDestination", expectedDestination);
            result.addResult(invalidValueCode, model);
        }
    }
}

