/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.ValidationResult;

public abstract class AbstractSamlValidationResult {
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;
    protected final ServiceProviderSpi serviceProviderSpi;
    protected final DateTime now;
    private final List<ValidationResult> results = new ArrayList<ValidationResult>();
    private String relayState;

    public AbstractSamlValidationResult(HttpServletRequest request, HttpServletResponse response, ServiceProviderSpi serviceProviderSpi, DateTime now) {
        this.request = request;
        this.response = response;
        this.serviceProviderSpi = serviceProviderSpi;
        this.now = now;
    }

    public void addResult(ResultType type) {
        this.addResult(type, Collections.emptyMap());
    }

    public void addResult(ResultType type, Map<String, Object> model) {
        this.results.add(new ValidationResult(type, model));
    }

    public List<ValidationResult> getResults() {
        return this.results;
    }

    public boolean hasErrors() {
        for (ValidationResult error : this.results) {
            if (error.getType().getKind() != ResultType.Kind.ERROR) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ResultType type) {
        return this.results.stream().anyMatch(r -> r.getType() == type);
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public ServiceProviderSpi getServiceProviderSpi() {
        return this.serviceProviderSpi;
    }

    public DateTime getNow() {
        return this.now;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

