/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.spi;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.security.credential.Credential;
import org.opensaml.storage.ReplayCache;
import org.opensaml.xmlsec.signature.Signature;

public interface ServiceProviderSpi {
    public String getACSLocation(HttpServletRequest var1);

    public String getLogoutLocation(HttpServletRequest var1);

    public String getIssuerName(HttpServletRequest var1);

    public Credential getSigningCredential();

    public String nextSamlRequestId();

    public String getIdpDestination(HttpServletRequest var1);

    public List<Credential> getIdentityProviderCredentials(Signature var1);

    public List<Credential> getAllIdentityProviderCredentials();

    public void responseValidationFailed(SamlResponseValidationResult var1) throws IOException;

    public void responseValidationSucceded(SamlResponseValidationResult var1) throws IOException;

    public int getIssueInstantLifeTimeMs();

    public boolean isForceAuthn(HttpServletRequest var1);

    public String getRelayState(HttpServletRequest var1, LogoutRequest var2);

    public String getRelayState(HttpServletRequest var1, AuthnRequest var2);

    public String getIdentityProviderId();

    public ReplayCache getReplayCache();

    public AuthnStateCache getAuthnStateCache(HttpServletRequest var1);

    public AuthnRequest buildAuthnRequest(HttpServletRequest var1);

    public Optional<SAMLSessionIdentification> getSessionIdentification(HttpServletRequest var1);

    public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy();

    public boolean isEncryptedAssertionsRequired();

    public boolean isSingleLogoutEnabled();

    public String getIdpSingleLogoutServiceURL();

    public void logoutSuccess(SamlLogoutValidationResult var1) throws IOException, ServletException;

    public void logoutFailed(SamlLogoutValidationResult var1) throws IOException;

    public void invalidateSession(HttpServletRequest var1, HttpServletResponse var2);
}

