/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.joda.time.DateTime;
import org.kantega.samllib.Binding;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlLogoutObjectValidator;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpLogoutServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SpLogoutServlet.class);

    protected abstract ServiceProviderSpi getServiceProviderSpi(HttpServletRequest var1);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServiceProviderSpi serviceProviderSpi = this.getServiceProviderSpi(req);
        if (req.getParameter("SAMLResponse") != null || req.getParameter("SAMLRequest") != null) {
            this.handleRequest(req, resp, Binding.HTTP_REDIRECT);
            return;
        }
        LogoutRequest logoutRequest = this.createLogoutRequest(req, serviceProviderSpi);
        MessageContext<SAMLObject> context = new MessageContext<SAMLObject>();
        context.setMessage(logoutRequest);
        String relayState = serviceProviderSpi.getRelayState(req, logoutRequest);
        if (relayState != null) {
            SAMLBindingSupport.setRelayState(context, relayState);
        } else {
            SAMLBindingSupport.setRelayState(context, "_none");
        }
        this.configurePeerEntityContext(context, serviceProviderSpi);
        this.configureSecurityParametersContext(context, serviceProviderSpi);
        log.debug("Invalidating session");
        serviceProviderSpi.invalidateSession(req, resp);
        try {
            HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
            encoder.setHttpServletResponse(resp);
            encoder.setMessageContext(context);
            encoder.initialize();
            encoder.encode();
        }
        catch (ComponentInitializationException | MessageEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp, Binding.HTTP_POST);
    }

    private void handleLogoutRequest(HttpServletRequest req, HttpServletResponse resp, MessageContext<SAMLObject> requestCtx, Binding binding) {
        String relayState;
        ServiceProviderSpi serviceProviderSpi = this.getServiceProviderSpi(req);
        LogoutRequest logoutRequest = (LogoutRequest)Objects.requireNonNull(requestCtx.getMessage(), "LogoutRequest must be non-null");
        SamlLogoutValidationResult result = new SamlLogoutValidationResult(req, resp, serviceProviderSpi, DateTime.now());
        new SamlLogoutObjectValidator(serviceProviderSpi).validateLogoutRequest(requestCtx, binding, result);
        LogoutResponse logoutResponse = this.createLogoutResponse(req, serviceProviderSpi, logoutRequest);
        if (result.hasErrors()) {
            Status status = new StatusBuilder().buildObject();
            StatusCode statusCode = new StatusCodeBuilder().buildObject();
            statusCode.setValue(result.contains(ResultType.LOGOUT_REQUEST_UNKNOWN_PRINCIPAL) ? "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal" : "urn:oasis:names:tc:SAML:2.0:status:Requester");
            status.setStatusCode(statusCode);
            logoutResponse.setStatus(status);
        } else {
            serviceProviderSpi.invalidateSession(req, resp);
        }
        MessageContext<SAMLObject> responseCtx = new MessageContext<SAMLObject>();
        responseCtx.setMessage(logoutResponse);
        this.configurePeerEntityContext(responseCtx, serviceProviderSpi);
        Credential signingCredential = serviceProviderSpi.getSigningCredential();
        if (signingCredential.getPrivateKey() != null) {
            SecurityParametersContext securityParametersContext = new SecurityParametersContext();
            SignatureSigningParameters params = new SignatureSigningParameters();
            params.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            params.setSigningCredential(signingCredential);
            params.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            securityParametersContext.setSignatureSigningParameters(params);
            responseCtx.addSubcontext(securityParametersContext);
        }
        if ((relayState = SAMLBindingSupport.getRelayState(requestCtx)) != null) {
            SAMLBindingSupport.setRelayState(responseCtx, relayState);
        } else {
            SAMLBindingSupport.setRelayState(responseCtx, "_none");
        }
        try {
            HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
            encoder.setHttpServletResponse(resp);
            encoder.setMessageContext(responseCtx);
            encoder.initialize();
            encoder.encode();
        }
        catch (ComponentInitializationException | MessageEncodingException e) {
            throw new RuntimeException("Failed to respond to LogoutRequest", e);
        }
    }

    private void handleLogoutResponse(HttpServletRequest req, HttpServletResponse resp, MessageContext<SAMLObject> ctx, Binding binding) throws IOException, ServletException {
        ServiceProviderSpi serviceProviderSpi = this.getServiceProviderSpi(req);
        SamlLogoutValidationResult result = new SamlLogoutValidationResult(req, resp, serviceProviderSpi, DateTime.now());
        new SamlLogoutObjectValidator(serviceProviderSpi).validateLogoutResponse(ctx, binding, result);
        if (result.hasErrors()) {
            serviceProviderSpi.logoutFailed(result);
        } else {
            serviceProviderSpi.logoutSuccess(result);
        }
    }

    private void handleRequest(HttpServletRequest req, HttpServletResponse resp, Binding binding) throws IOException, ServletException {
        block4: {
            try {
                BaseHttpServletRequestXMLMessageDecoder<SAMLObject> decoder2 = binding.getDecoder();
                decoder2.setHttpServletRequest(req);
                decoder2.initialize();
                decoder2.decode();
                MessageContext<SAMLObject> ctx = decoder2.getMessageContext();
                SAMLObject samlObject = (SAMLObject)ctx.getMessage();
                if (samlObject instanceof LogoutResponse) {
                    this.handleLogoutResponse(req, resp, ctx, binding);
                    break block4;
                }
                if (samlObject instanceof LogoutRequest) {
                    this.handleLogoutRequest(req, resp, ctx, binding);
                    break block4;
                }
                String cls = samlObject == null ? null : samlObject.getClass().getName();
                throw new RuntimeException("Unexpected SAMLObject: " + cls);
            }
            catch (ComponentInitializationException | MessageDecodingException e) {
                throw new RuntimeException("Failed to decode SAMLRequest", e);
            }
        }
    }

    private LogoutRequest createLogoutRequest(HttpServletRequest req, ServiceProviderSpi serviceProviderSpi) {
        SAMLSessionIdentification si = serviceProviderSpi.getSessionIdentification(req).orElseThrow(() -> new RuntimeException("No SessionIdentification available, cannot create LogoutRequest"));
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        logoutRequest.setReason("urn:oasis:names:tc:SAML:2.0:logout:user");
        logoutRequest.setIssueInstant(DateTime.now());
        logoutRequest.setID(serviceProviderSpi.nextSamlRequestId());
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(serviceProviderSpi.getIssuerName(req));
        logoutRequest.setIssuer(issuer);
        NameID nameId = new NameIDBuilder().buildObject();
        nameId.setValue(si.getNameId());
        nameId.setFormat(si.getNameIdFormat());
        logoutRequest.setNameID(nameId);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(si.getSessionIndex());
        logoutRequest.getSessionIndexes().add(sessionIndex);
        logoutRequest.setDestination(serviceProviderSpi.getIdpSingleLogoutServiceURL());
        return logoutRequest;
    }

    private LogoutResponse createLogoutResponse(HttpServletRequest req, ServiceProviderSpi serviceProviderSpi, LogoutRequest logoutRequest) {
        LogoutResponse logoutResponse = new LogoutResponseBuilder().buildObject();
        logoutResponse.setIssueInstant(DateTime.now());
        logoutResponse.setID(serviceProviderSpi.nextSamlRequestId());
        logoutResponse.setInResponseTo(logoutRequest.getID());
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(serviceProviderSpi.getIssuerName(req));
        logoutResponse.setIssuer(issuer);
        Status status = new StatusBuilder().buildObject();
        StatusCode statusCode = new StatusCodeBuilder().buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        logoutResponse.setStatus(status);
        logoutResponse.setDestination(serviceProviderSpi.getIdpSingleLogoutServiceURL());
        return logoutResponse;
    }

    private void configureSecurityParametersContext(MessageContext<SAMLObject> context, ServiceProviderSpi serviceProviderSpi) {
        Credential signingCredential = serviceProviderSpi.getSigningCredential();
        if (signingCredential.getPrivateKey() == null) {
            throw new RuntimeException("Missing signing credential private key, cannot sign.");
        }
        SecurityParametersContext securityParametersContext = new SecurityParametersContext();
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signingParameters.setSigningCredential(signingCredential);
        signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        securityParametersContext.setSignatureSigningParameters(signingParameters);
        SignatureValidationParameters validationParameters = new SignatureValidationParameters();
        StaticCredentialResolver credentialResolver = new StaticCredentialResolver(serviceProviderSpi.getAllIdentityProviderCredentials());
        validationParameters.setSignatureTrustEngine(new ExplicitKeySignatureTrustEngine(credentialResolver, new StaticKeyInfoCredentialResolver(signingCredential)));
        securityParametersContext.setSignatureValidationParameters(validationParameters);
        context.addSubcontext(securityParametersContext);
    }

    private void configurePeerEntityContext(MessageContext<SAMLObject> context, ServiceProviderSpi serviceProviderSpi) {
        SAMLPeerEntityContext peerEntityContext = new SAMLPeerEntityContext();
        SAMLEndpointContext endpointContext = new SAMLEndpointContext();
        SingleLogoutService endpoint = new SingleLogoutServiceBuilder().buildObject();
        endpoint.setLocation(serviceProviderSpi.getIdpSingleLogoutServiceURL());
        endpointContext.setEndpoint(endpoint);
        peerEntityContext.addSubcontext(endpointContext);
        context.addSubcontext(peerEntityContext);
    }
}

