/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kantega.samllib.IdpServlet;
import org.kantega.samllib.spi.AuthnState;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.SamlResponseValidator;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AuthzService;
import org.opensaml.saml.saml2.metadata.impl.AuthzServiceBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.w3c.dom.Element;

public abstract class SpLoginServlet
extends HttpServlet {
    protected void doGet(final HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServiceProviderSpi serviceProviderSpi = this.getServiceProviderSpi(req);
        if (serviceProviderSpi == null) {
            resp.sendError(404);
            return;
        }
        AuthnRequest authnRequest = serviceProviderSpi.buildAuthnRequest(req);
        AuthnStateCache authnStateCache = serviceProviderSpi.getAuthnStateCache(req);
        authnStateCache.put(authnRequest.getID(), new AuthnState());
        MessageContext<SAMLObject> context = new MessageContext<SAMLObject>();
        context.setMessage(authnRequest);
        SAMLPeerEntityContext peerEntityContext = new SAMLPeerEntityContext();
        SAMLEndpointContext endpointContext = new SAMLEndpointContext();
        AuthzService endpoint = new AuthzServiceBuilder().buildObject();
        endpoint.setLocation(serviceProviderSpi.getIdpDestination(req));
        endpointContext.setEndpoint(endpoint);
        peerEntityContext.addSubcontext(endpointContext);
        context.addSubcontext(peerEntityContext);
        Credential signingCredential = serviceProviderSpi.getSigningCredential();
        if (signingCredential.getPrivateKey() != null) {
            SecurityParametersContext securityParametersContext = new SecurityParametersContext();
            SignatureSigningParameters params = new SignatureSigningParameters();
            params.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            params.setSigningCredential(signingCredential);
            params.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            securityParametersContext.setSignatureSigningParameters(params);
            context.addSubcontext(securityParametersContext);
        }
        final List<String> params = Arrays.asList("username", "login_hint", "hd");
        String relayState = serviceProviderSpi.getRelayState(req, authnRequest);
        if (relayState != null) {
            SAMLBindingSupport.setRelayState(context, relayState);
        } else {
            SAMLBindingSupport.setRelayState(context, "_none");
            relayState = "_none";
        }
        Boolean usePostBinding = (Boolean)req.getAttribute("usePostBinding");
        if (usePostBinding != null && usePostBinding.booleanValue()) {
            this.doUsePostBinding(req, resp, context, endpoint, params, relayState);
            return;
        }
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder(){

            @Override
            protected String buildRedirectURL(MessageContext<SAMLObject> messageContext, String endpoint, String message) throws MessageEncodingException {
                String redirectURL = super.buildRedirectURL(messageContext, endpoint, message);
                try {
                    URLBuilder redirectURLBuilder = new URLBuilder(redirectURL);
                    List<Pair<String, String>> redirectQueryParams = redirectURLBuilder.getQueryParams();
                    params.forEach(paramName -> {
                        String param = req.getParameter(paramName);
                        if (param != null) {
                            redirectQueryParams.add(new Pair<String, String>((String)paramName, param));
                        }
                    });
                    redirectQueryParams.addAll(new URLBuilder(endpoint).getQueryParams());
                    return redirectURLBuilder.buildURL();
                }
                catch (MalformedURLException e) {
                    throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", e);
                }
            }
        };
        encoder.setHttpServletResponse(resp);
        encoder.setMessageContext(context);
        try {
            encoder.initialize();
            encoder.encode();
        }
        catch (ComponentInitializationException | MessageEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void doUsePostBinding(HttpServletRequest req, HttpServletResponse resp, MessageContext<SAMLObject> context, AuthzService endpoint, List<String> params, String relayState) throws IOException {
        HttpServletSupport.addNoCacheHeaders(resp);
        HttpServletSupport.setUTF8Encoding(resp);
        HttpServletSupport.setContentType(resp, "text/html");
        URL template = ((Object)((Object)this)).getClass().getResource("/idp/postRequest.html");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        params.forEach(paramName -> {
            String param;
            if (StringUtils.isNotBlank(paramName) && (param = req.getParameter(paramName)) != null) {
                paramsMap.put((String)paramName, param);
            }
        });
        try {
            resp.getWriter().write(IdpServlet.render(template, endpoint.getLocation(), Base64.getEncoder().encodeToString(SerializeSupport.nodeToString(this.marshallMessage(context.getMessage())).getBytes(StandardCharsets.UTF_8)), relayState, paramsMap));
        }
        catch (MessageEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        try {
            return XMLObjectSupport.marshall(message);
        }
        catch (MarshallingException var3) {
            throw new MessageEncodingException("Error marshalling message", var3);
        }
    }

    protected abstract ServiceProviderSpi getServiceProviderSpi(HttpServletRequest var1);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServiceProviderSpi serviceProviderSpi = this.getServiceProviderSpi(req);
        SamlResponseValidationResult result = new SamlResponseValidationResult(req, resp, serviceProviderSpi, DateTime.now());
        try {
            SAMLObject samlObject;
            HTTPPostDecoder decoder2 = new HTTPPostDecoder();
            decoder2.setHttpServletRequest(req);
            decoder2.initialize();
            decoder2.decode();
            String relayState = SAMLBindingSupport.getRelayState(decoder2.getMessageContext());
            if (!"_none".equals(relayState)) {
                result.setRelayState(relayState);
            }
            if ((samlObject = (SAMLObject)decoder2.getMessageContext().getMessage()) instanceof Response) {
                Response samlResponse = (Response)samlObject;
                new SamlResponseValidator(serviceProviderSpi.getReplayCache(), serviceProviderSpi.getAuthnStateCache(req), serviceProviderSpi).validate(samlResponse, result);
                if (result.hasErrors()) {
                    this.invalidSamlResponse(serviceProviderSpi, result);
                } else {
                    this.successfulAuthentication(serviceProviderSpi, result);
                }
            } else {
                result.addResult(ResultType.SAML_MESSAGE_NOT_RESPONSE, Collections.singletonMap("responseObject", samlObject));
                this.invalidSamlResponse(serviceProviderSpi, result);
            }
        }
        catch (ComponentInitializationException | MessageDecodingException e) {
            result.addResult(ResultType.EXCEPTION_DECODING_RESPONSE, Collections.singletonMap("e", e));
            this.invalidSamlResponse(serviceProviderSpi, result);
        }
    }

    protected void successfulAuthentication(ServiceProviderSpi serviceProviderSpi, SamlResponseValidationResult result) throws IOException {
        serviceProviderSpi.responseValidationSucceded(result);
    }

    protected void invalidSamlResponse(ServiceProviderSpi serviceProviderSpi, SamlResponseValidationResult result) throws IOException {
        serviceProviderSpi.responseValidationFailed(result);
    }
}

