/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import kantega.shaded.com.google.common.io.ByteStreams;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.text.StringEscapeUtils;
import org.joda.time.DateTime;
import org.kantega.samllib.spi.Identity;
import org.kantega.samllib.spi.IdentityProviderSpi;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSStringBuilder;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPRedirectDeflateSignatureSecurityHandler;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml.saml2.core.impl.AttributeBuilder;
import org.opensaml.saml.saml2.core.impl.AttributeStatementBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnStatementBuilder;
import org.opensaml.saml.saml2.core.impl.ConditionsBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.core.impl.SubjectBuilder;
import org.opensaml.saml.saml2.core.impl.SubjectConfirmationBuilder;
import org.opensaml.saml.saml2.core.impl.SubjectConfirmationDataBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;

public class IdpServlet
extends HttpServlet {
    private final IdentityProviderSpi identityProviderSpi;

    public IdpServlet(IdentityProviderSpi identityProviderSpi) {
        this.identityProviderSpi = identityProviderSpi;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HTTPRedirectDeflateDecoder deflateDecoder = new HTTPRedirectDeflateDecoder();
        deflateDecoder.setHttpServletRequest(req);
        try {
            deflateDecoder.initialize();
            deflateDecoder.decode();
            MessageContext<SAMLObject> messageContext = deflateDecoder.getMessageContext();
            if (!this.validateSignature(req, messageContext)) {
                resp.sendError(400);
                return;
            }
            if (messageContext.getMessage() instanceof AuthnRequest) {
                AuthnRequest authnRequest = (AuthnRequest)messageContext.getMessage();
                Optional<Identity> identity = this.identityProviderSpi.getLoggedInIdentity(req);
                if (authnRequest.isForceAuthn().booleanValue() && !this.identityProviderSpi.hasAuthenticated(req) || !identity.isPresent()) {
                    this.identityProviderSpi.initiateLogin(req, resp);
                    return;
                }
                Response response = this.buildResponse(authnRequest, identity.get());
                String messageXML = SerializeSupport.nodeToString(XMLObjectSupport.marshall(response));
                String encodedMessage = Base64Support.encode(messageXML.getBytes(StandardCharsets.UTF_8), false);
                HttpServletSupport.addNoCacheHeaders(resp);
                HttpServletSupport.setUTF8Encoding(resp);
                HttpServletSupport.setContentType(resp, "text/html");
                URL template = ((Object)((Object)this)).getClass().getResource("/idp/post.html");
                resp.getWriter().write(IdpServlet.render(template, authnRequest.getAssertionConsumerServiceURL(), encodedMessage, "", new HashMap<String, String>()));
                return;
            }
        }
        catch (ComponentInitializationException | MarshallingException | MessageDecodingException e) {
            throw new RuntimeException(e);
        }
        resp.sendError(400);
    }

    private boolean validateSignature(HttpServletRequest req, MessageContext<SAMLObject> messageContext) {
        if (!(messageContext.getMessage() instanceof AuthnRequest)) {
            return false;
        }
        AuthnRequest authnRequest = (AuthnRequest)messageContext.getMessage();
        String issuer = authnRequest.getIssuer().getValue();
        if (!this.identityProviderSpi.isServiceProvider(issuer)) {
            return false;
        }
        return this.validateSignature(req, messageContext, issuer);
    }

    private boolean validateSignature(HttpServletRequest req, MessageContext<SAMLObject> messageContext, String issuer) {
        try {
            SAMLPeerEntityContext peerEntityContext = new SAMLPeerEntityContext();
            peerEntityContext.setRole(new QName("p:p"));
            messageContext.addSubcontext(peerEntityContext);
            SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
            samlProtocolContext.setProtocol("proto");
            messageContext.addSubcontext(samlProtocolContext);
            SecurityParametersContext securityParametersContext = new SecurityParametersContext();
            SignatureValidationParameters params = new SignatureValidationParameters();
            Credential serviceProviderCredential = this.identityProviderSpi.getServiceProviderCredential(issuer);
            StaticCredentialResolver credentialResolver = new StaticCredentialResolver(serviceProviderCredential);
            params.setSignatureTrustEngine(new ExplicitKeySignatureTrustEngine(credentialResolver, new StaticKeyInfoCredentialResolver(serviceProviderCredential)));
            securityParametersContext.setSignatureValidationParameters(params);
            messageContext.addSubcontext(securityParametersContext);
            SAML2HTTPRedirectDeflateSignatureSecurityHandler signatureSecurityHandler = new SAML2HTTPRedirectDeflateSignatureSecurityHandler();
            signatureSecurityHandler.setHttpServletRequest(req);
            signatureSecurityHandler.initialize();
            signatureSecurityHandler.invoke(messageContext);
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException(e);
        }
        catch (MessageHandlerException e) {
            return false;
        }
        return true;
    }

    public static String escapeHtml(String s) {
        return StringEscapeUtils.escapeHtml4(s);
    }

    public static String render(URL resource, String uri, String encodedSamlMessage, String relayState, Map<String, String> params) throws IOException {
        String sanitizedExtraParams = params.entrySet().stream().map(paramKeyValue -> String.format("<input type=\"hidden\" name=\"%s\" value=\"%s\">", IdpServlet.escapeHtml((String)paramKeyValue.getKey()), IdpServlet.escapeHtml((String)paramKeyValue.getValue()))).reduce("", (a, b) -> a + System.lineSeparator() + b);
        try (InputStream is = resource.openStream();){
            String template = new String(ByteStreams.toByteArray(is), StandardCharsets.UTF_8);
            String string = String.format(template, IdpServlet.escapeHtml(uri), IdpServlet.escapeHtml(encodedSamlMessage), IdpServlet.escapeHtml(relayState), sanitizedExtraParams);
            return string;
        }
    }

    private Response buildResponse(AuthnRequest authnRequest, Identity user) {
        try {
            Response response = new ResponseBuilder().buildObject();
            response.setID(this.identityProviderSpi.nextResponseID());
            Status status = new StatusBuilder().buildObject();
            StatusCode statusCode = new StatusCodeBuilder().buildObject();
            statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
            status.setStatusCode(statusCode);
            response.setStatus(status);
            response.setIssueInstant(DateTime.now());
            response.setInResponseTo(authnRequest.getID());
            Assertion assertion = new AssertionBuilder().buildObject();
            assertion.setID(this.identityProviderSpi.nextAssertionID());
            assertion.setIssueInstant(DateTime.now());
            Issuer issuer = new IssuerBuilder().buildObject();
            issuer.setValue(this.identityProviderSpi.getLocation());
            assertion.setIssuer(issuer);
            Subject subject = new SubjectBuilder().buildObject();
            NameID nameID = new NameIDBuilder().buildObject();
            nameID.setValue(user.getEmailAddress());
            subject.setNameID(nameID);
            SubjectConfirmation subjectConfirmation = new SubjectConfirmationBuilder().buildObject();
            subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
            SubjectConfirmationData subjectConfirmationData = new SubjectConfirmationDataBuilder().buildObject();
            subjectConfirmationData.setNotOnOrAfter(DateTime.now().plusMinutes(5));
            subjectConfirmationData.setRecipient(authnRequest.getAssertionConsumerServiceURL());
            subjectConfirmationData.setInResponseTo(authnRequest.getID());
            subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
            subject.getSubjectConfirmations().add(subjectConfirmation);
            assertion.setSubject(subject);
            Conditions conditions = new ConditionsBuilder().buildObject();
            conditions.setNotBefore(DateTime.now().minusMinutes(1));
            conditions.setNotOnOrAfter(DateTime.now().plusMinutes(5));
            assertion.setConditions(conditions);
            AuthnStatement authnStatement = new AuthnStatementBuilder().buildObject();
            authnStatement.setAuthnInstant(DateTime.now());
            AuthnContext authnContext = new AuthnContextBuilder().buildObject();
            AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            authnContext.setAuthnContextClassRef(authnContextClassRef);
            authnStatement.setAuthnContext(authnContext);
            assertion.getStatements().add(authnStatement);
            AttributeStatement attributeStatement = new AttributeStatementBuilder().buildObject();
            assertion.getAttributeStatements().add(attributeStatement);
            Attribute nameAttribute = this.stringAttribute("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name", user.getName());
            attributeStatement.getAttributes().add(nameAttribute);
            Attribute emailAttribute = this.stringAttribute("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress", user.getEmailAddress());
            attributeStatement.getAttributes().add(emailAttribute);
            response.getAssertions().add(assertion);
            SignatureImpl signature = new SignatureBuilder().buildObject();
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            signature.setSigningCredential(this.identityProviderSpi.getSigningCredential());
            response.setSignature(signature);
            MarshallerFactory marshallerFactory = ConfigurationService.get(XMLObjectProviderRegistry.class).getMarshallerFactory();
            marshallerFactory.getMarshaller(response).marshall(response);
            Signer.signObject(signature);
            return response;
        }
        catch (MarshallingException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private Attribute stringAttribute(String name, String value) {
        Attribute emailAttribute = new AttributeBuilder().buildObject();
        emailAttribute.setName(name);
        XSString email = (XSString)new XSStringBuilder().buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        email.setValue(value);
        emailAttribute.getAttributeValues().add(email);
        return emailAttribute;
    }

    class User {
        final String username;
        final String name;
        final String email;

        public User(String username, String name, String email) {
            this.username = username;
            this.name = name;
            this.email = email;
        }
    }
}

