/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

public class TestUtils {
    public static boolean isTest(HttpServletRequest request) {
        return Try.of(() -> request.getParameter("test") != null).getOrElse(false);
    }

    public static Try<Void> recordTestFailedBeforeRequest(OIDCIdpConfiguration idpConfig, IdpConfManager idpConfManager, Either<String, OidcProcedureData> oidcProcedureData, Option<String> maybeTestId, ErrorUtils.KssoError error, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> maybeTestId.peek(testId -> idpConfManager.recordErrorTestOIDCProcedureBeforeRequest(idpConfig.getId(), (String)testId, (OidcProcedureData)oidcProcedureData.get(), error, evaluationCode)));
    }

    public static Try<Void> recordTestProcedureBeforeRequest(OIDCIdpConfiguration idpConfig, IdpConfManager idpConfManager, Either<String, OidcProcedureData> oidcProcedureData, Option<String> maybeTestId, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> maybeTestId.peek(testId -> idpConfManager.recordTestOIDCProcedureBeforeRequest(idpConfig.getId(), (String)testId, (OidcProcedureData)oidcProcedureData.get(), evaluationCode)));
    }

    public static Try<Void> recordTestFailedAfterResponse(OIDCIdpConfiguration idpConfig, IdpConfManager idpConfManager, Either<String, OidcProcedureData> oidcProcedureData, Option<String> maybeTestId, ErrorUtils.KssoError error, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> maybeTestId.peek(testId -> idpConfManager.recordErrorTestOIDCProcedureAfterResponse(idpConfig.getId(), (String)testId, (OidcProcedureData)oidcProcedureData.get(), error, evaluationCode)));
    }

    public static Try<Void> recordTestProcedureAfterResponse(OIDCIdpConfiguration idpConfig, IdpConfManager idpConfManager, Either<String, OidcProcedureData> oidcProcedureData, Option<String> maybeTestId, ResponseEvaluationCode evaluationCode) {
        return Try.run(() -> maybeTestId.peek(testId -> idpConfManager.recordTestOIDCProcedureAfterResponse(idpConfig.getId(), (String)testId, (OidcProcedureData)oidcProcedureData.get(), evaluationCode)));
    }

    public static void renderTestResult(HttpServletRequest req, HttpServletResponse resp, IdpConfiguration idpConfig, IdpConfManager idpConfManager, UserManager userManager, String testId) throws IOException {
        resp.sendRedirect(TestUtils.testResultURL(req, idpConfig, idpConfManager, userManager, testId));
    }

    public static String testResultURL(HttpServletRequest req, IdpConfiguration idpConfig, IdpConfManager idpConfManager, UserManager userManager, String testId) {
        Try<URIBuilder> uriBuilder = HttpUrlUtils.isSystemAdmin(userManager, req) ? Try.of(() -> idpConfManager.getServiceProviderEvaluateTestURL(req, idpConfig.getId())).mapTry(URIBuilder::new).mapTry(builder -> builder.addParameter("id", testId)) : Try.of(() -> idpConfManager.getServiceProviderNonAdminTestURL(req, idpConfig.getId())).mapTry(URIBuilder::new).mapTry(builder -> builder.addParameter("ack", "true")).mapTry(builder -> builder.addParameter("testID", testId));
        String location = uriBuilder.mapTry(URIBuilder::build).mapTry(URI::toString).getOrElseThrow(throwable -> new RuntimeException(ErrorUtils.createKssoError("[KSSO-UGYKG1O5ZH]", "Failed to show test results: ").asMessage() + throwable));
        return location;
    }
}

