/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public final class ListParseUtils {
    public static Set<String> parseSetFromCommaseparated(String commaseparatedList) {
        TreeSet<String> result = new TreeSet<String>();
        if (commaseparatedList != null) {
            for (String g : commaseparatedList.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                result.add(g);
            }
        }
        return result;
    }

    public static String[] parseArrayFromCommaseparated(String commaseparatedList) {
        if (!StringUtils.isEmpty(commaseparatedList)) {
            String[] result = commaseparatedList.split(",");
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].trim().toLowerCase();
            }
            return result;
        }
        return new String[0];
    }

    public static List<String> parseListFromCommaSeparated(String commaseparatedList) {
        Set<String> parsedSet = ListParseUtils.parseSetFromCommaseparated(commaseparatedList);
        return Lists.newArrayList(parsedSet);
    }

    public static String[] parseArrayFromNewlines(String listString) {
        if (listString == null) {
            return null;
        }
        ArrayList<String> comps = new ArrayList<String>();
        for (String split : listString.split(",|(\\r?\n)")) {
            if ((split = split.trim()).isEmpty()) continue;
            comps.add(split);
        }
        return comps.toArray(new String[0]);
    }

    public static String arrayToStringWithNewlines(String[] array) {
        return StringUtils.join((Object[])array, "\n");
    }

    public static String iterableToCommaSeparatedString(Iterable<String> iterable) {
        return StringUtils.join(iterable, ",");
    }
}

