/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import shaded.org.apache.commons.codec.binary.Base64;

public class HttpUrlUtils {
    public static boolean validateURL(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            return scheme != null && (scheme.equals("https") || scheme.equals("http"));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValidURI(String maybeUri) throws URISyntaxException, NullPointerException {
        URI uri = new URI(maybeUri);
        String scheme = uri.getScheme();
        return scheme != null && (scheme.equals("https") || scheme.equals("http"));
    }

    public static Try<URI> tryNormalizeURI(String taintedURI) {
        return Try.of(() -> taintedURI).mapTry(uri -> uri.replaceAll("\\s+", "")).mapTry(URI::new).mapTry(URI::normalize);
    }

    public static String getIdPIdFromPath(HttpServletRequest req) {
        return Try.of(() -> {
            String p = req.getPathInfo();
            p = p.substring(0, p.lastIndexOf("/"));
            return p.substring(p.lastIndexOf("/") + 1);
        }).getOrElse("");
    }

    public static String getPluginAdminBase(HttpServletRequest request) {
        return request.getContextPath() + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin";
    }

    public static String stripPrefixFromUri(String uriPath, String maybePrefix) {
        String prefix = Option.of(maybePrefix).getOrElse("");
        return Try.of(() -> uriPath).mapTry(uri -> uri.startsWith(prefix) ? uri.replaceFirst(prefix, "") : uri).flatMapTry(HttpUrlUtils::tryNormalizeURI).mapTry(URI::getPath).getOrElse(uriPath);
    }

    public static String addPrefixIfNotInPath(String uriPath, String prefix) {
        return Try.of(() -> uriPath).map(HttpUrlUtils::sanitizeUrlForTrailingSlashes).mapTry(uri -> uri.startsWith(prefix) ? uri : prefix + uri).flatMapTry(HttpUrlUtils::tryNormalizeURI).mapTry(URI::getPath).getOrElse(uriPath);
    }

    public static boolean isRemoteIpValveConfigured() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().contains("RemoteIpValve")) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemAdmin(UserManager userManager, HttpServletRequest request) {
        UserKey remoteUser = userManager.getRemoteUserKey(request);
        return remoteUser != null && userManager.isSystemAdmin(remoteUser);
    }

    public static String getInternalPath(String uri, String contextPath) {
        return uri.substring(contextPath.length());
    }

    public static String getInternalPath(HttpServletRequest req) {
        return HttpUrlUtils.getInternalPath(req.getRequestURI(), req.getContextPath());
    }

    private static boolean isAuthHeaderValueBasic(String authzHeaderValue) {
        return StringUtils.startsWithIgnoreCase(authzHeaderValue, "Basic");
    }

    public static boolean requestHasBasicAuth(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!HttpUrlUtils.isAuthHeaderValueBasic(header)) continue;
            return true;
        }
        return false;
    }

    public static String getBasicAuthHeader(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!HttpUrlUtils.isAuthHeaderValueBasic(header)) continue;
            return header;
        }
        return null;
    }

    public static Option<Tuple2<String, String>> credentialsWithBasicAuthentication(HttpServletRequest req) {
        Enumeration headers = req.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String basic = (String)headers.nextElement();
            if (!headers.hasMoreElements() || !HttpUrlUtils.isAuthHeaderValueBasic(basic)) continue;
            String basicBase64Encoded = basic + " " + (String)headers.nextElement();
            return HttpUrlUtils.getCredentialsFromBasicAuthHeader(basicBase64Encoded);
        }
        return Option.none();
    }

    public static Option<Tuple2<String, String>> credentialsWithBasicAuthSingleHeader(HttpServletRequest request) {
        return Option.of(request).map(req -> req.getHeader("Authorization")).flatMap(HttpUrlUtils::getCredentialsFromBasicAuthHeader);
    }

    public static Option<Tuple2<String, String>> getCredentialsFromBasicAuthHeader(String authHeader) {
        return Option.of(authHeader).filter(HttpUrlUtils::isAuthHeaderValueBasic).map(basicAuthHeader -> StringUtils.substringAfter(basicAuthHeader, " ")).map(basicAuthBody -> Base64.decodeBase64(basicAuthBody.getBytes(StandardCharsets.UTF_8))).map(bytes -> StringUtils.toEncodedString(bytes, StandardCharsets.UTF_8)).filter(credentials -> credentials.contains(":")).map(credentials -> Tuple.of(StringUtils.substringBefore(credentials, ":"), StringUtils.substringAfter(credentials, ":"))).map(tuple -> tuple.map(String::trim, String::trim)).filter(tuple -> StringUtils.isNotBlank((CharSequence)tuple._1()));
    }

    public static String sanitizeUrlForTrailingSlashes(String taintedUrl) {
        return Try.of(() -> taintedUrl).mapTry(url -> url.endsWith("/") ? url.substring(0, url.length() - 1) : url).getOrElse(taintedUrl);
    }

    public static String urlEncode(String value) throws UnsupportedEncodingException {
        return value == null ? "" : URLEncoder.encode(value, "UTF-8");
    }

    public static boolean isValidAndNonEmptyUri(String maybeValidUri) {
        return Option.of(maybeValidUri).filter(StringUtils::isNotBlank).filter(StringUtils::isNotEmpty).map(HttpUrlUtils::validateURL).getOrElse(false);
    }

    public static String transformToAbsoluteUrl(String url, ApplicationProperties applicationProperties) {
        if (StringUtils.isBlank(url)) {
            return url;
        }
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            try {
                return UriBuilder.fromUri((String)applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).path(url).build(new Object[0]).toURL().toString();
            }
            catch (MalformedURLException ee) {
                return null;
            }
        }
        return url;
    }
}

