/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;

@Scanned
public class DirectoryGroupsAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final ScimConfManager scimConfManager;

    @Inject
    public DirectoryGroupsAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        String tenantId = req.getParameter("tenantId");
        String filter = req.getParameter("filter");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = maybeDirectory.get();
        int startIndex = 0;
        if (req.getParameter("start-index") != null) {
            startIndex = Integer.parseInt(req.getParameter("start-index"));
        }
        model.put("currentScimDirectory", scimDirectory);
        model.put("topMenu", "connectors");
        model.put("menuItem", "scimDirectoryGroups");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("groupFilter", filter);
        Object filterRestriction = filter == null || filter.trim().isEmpty() ? NullRestrictionImpl.INSTANCE : new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)filter);
        this.render(scimDirectory.getDirectory(), resp, model, (SearchRestriction)filterRestriction, startIndex);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String startIndex;
        String tenantId = req.getParameter("tenantId");
        String operation = req.getParameter("operation");
        String groupName = req.getParameter("groupName");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = maybeDirectory.get();
        if ("deleteGroup".equals(operation)) {
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            try {
                directoryManager.removeGroup(scimDirectory.getDirectoryId(), groupName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String query = "?tenantId=" + tenantId;
        String filter = req.getParameter("filter");
        if (StringUtils.isNotEmpty(filter)) {
            query = query + "&filter=" + filter;
        }
        if (StringUtils.isNotEmpty(startIndex = req.getParameter("start-index"))) {
            query = query + "&start-index=" + startIndex;
        }
        resp.sendRedirect("groups" + query);
    }

    private void render(Directory dir, HttpServletResponse resp, Map<String, Object> model, SearchRestriction restriction, int startIndex) throws IOException {
        try {
            boolean isFirst;
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            int maxResults = 50;
            EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with(restriction).startingAt(startIndex).returningAtMost(maxResults);
            List groups2 = directoryManager.searchGroups(dir.getId().longValue(), groupQuery);
            model.put("directoryGroups", groups2);
            model.put("firstIndex", startIndex + 1);
            model.put("lastIndex", Math.max(1, startIndex + groups2.size()));
            boolean isMore = maxResults == groups2.size();
            boolean bl = isFirst = startIndex == 0;
            if (isMore) {
                model.put("nextIndex", startIndex + groups2.size());
            }
            if (!isFirst) {
                model.put("prevIndex", startIndex - maxResults);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            this.renderer.render("templates/atlaskerb/scim/groups.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

