/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.ksso.scim.atlassian.auth.BasicAuthCredentials;
import com.ksso.scim.atlassian.auth.BearerTokenCredentials;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.NoCredentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;

@Scanned
public class AdvancedScimSettingsAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public AdvancedScimSettingsAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tenantId = req.getParameter("tenantId");
        if (StringUtils.isBlank(tenantId)) {
            resp.sendError(404);
            return;
        }
        Map<String, Object> model = this.newModel(req);
        ScimDirectory scimDirectory = this.getScimDirectory(tenantId);
        ScimTenantConfig config = scimDirectory.getConfig();
        model.put("currentScimDirectory", scimDirectory);
        model.put("tenantId", tenantId);
        model.put("tenantName", config.getTenantName());
        model.put("scimAuthMethod", (Object)config.getScimAuthMethod());
        model.put("kind", (Object)config.getKind());
        this.renderPage(resp, model);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ScimAuthMethod scimAuthMethod;
        String changeAuthMethod = req.getParameter("actionChangeAuthMethod");
        String saveCredentials = req.getParameter("actionSaveCredentials");
        String tenantId = req.getParameter("tenantId");
        ScimDirectory existingDirectory = this.getScimDirectory(tenantId);
        ScimTenantConfig existingConfig = existingDirectory.getConfig();
        Credentials existingCredentials = existingConfig.getCredentials();
        if (StringUtils.isNotBlank(changeAuthMethod) && (scimAuthMethod = Try.of(() -> ScimAuthMethod.valueOf(req.getParameter("scimAuthMethod"))).getOrElse(ScimAuthMethod.BEARER)) != existingCredentials.getAuthMethod()) {
            Map<String, Object> model = this.newModel(req);
            model.put("currentScimDirectory", existingDirectory);
            model.put("tenantId", tenantId);
            model.put("tenantName", existingConfig.getTenantName());
            model.put("scimAuthMethod", (Object)scimAuthMethod);
            model.put("kind", (Object)existingConfig.getKind());
            model.put("showSaveCredentialsDialog", true);
            if (scimAuthMethod == ScimAuthMethod.BEARER) {
                String applicationSecretPlainText = this.scimConfManager.nextPassword();
                model.put("applicationSecretPlainText", applicationSecretPlainText);
            } else if (scimAuthMethod == ScimAuthMethod.BASIC) {
                String plainTextPassword = this.scimConfManager.nextPassword();
                model.put("username", tenantId);
                model.put("plainTextPassword", plainTextPassword);
            }
            this.renderPage(resp, model);
            return;
        }
        if (StringUtils.isNotBlank(saveCredentials)) {
            Credentials newCredentials;
            String salt;
            scimAuthMethod = Try.of(() -> ScimAuthMethod.valueOf(req.getParameter("scimAuthMethod"))).getOrElse(ScimAuthMethod.BEARER);
            if (scimAuthMethod == ScimAuthMethod.BEARER) {
                salt = this.scimConfManager.nextId();
                String applicationSecretPlainText = req.getParameter("applicationSecretPlainText");
                newCredentials = BearerTokenCredentials.createHash(salt, applicationSecretPlainText);
            } else if (scimAuthMethod == ScimAuthMethod.BASIC) {
                salt = this.scimConfManager.nextId();
                String plainTextPassword = req.getParameter("plainTextPassword");
                newCredentials = BasicAuthCredentials.createHash(tenantId, salt, plainTextPassword);
            } else {
                newCredentials = new NoCredentials();
            }
            ScimTenantConfig newCfg = new ScimTenantConfig(existingConfig.getTenantId(), existingConfig.getTenantName(), newCredentials, scimAuthMethod, existingConfig.getKind());
            this.scimConfManager.saveOrUpdate(newCfg);
        }
        resp.sendRedirect("advanced-scim-settings?tenantId=" + tenantId);
    }

    private ScimDirectory getScimDirectory(String tenantId) {
        return this.scimConfManager.getScimDirectory(tenantId).getOrElseThrow(() -> new RuntimeException("SCIM tenantId not found: " + tenantId));
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "advancedScimSettings");
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/scim/advanced-scim-settings.vm", model, (Writer)resp.getWriter());
    }
}

