/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim;

import com.kantegasso.jsonmapping.JsonMapping;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;

public class ScimTenantConfig
implements DebugInfo {
    private final String tenantId;
    private final String tenantName;
    private final Credentials credentials;
    private final ScimProviderKind kind;
    private final ScimAuthMethod scimAuthMethod;

    public ScimTenantConfig(@JsonMapping.JsonProperty(value="tenantId") String tenantId, @JsonMapping.JsonProperty(value="tenantName") String tenantName, @JsonMapping.JsonProperty(value="credentials") Credentials credentials, @JsonMapping.JsonProperty(value="authMethod") ScimAuthMethod scimAuthMethod, @JsonMapping.JsonProperty(value="kind") ScimProviderKind kind) {
        this.tenantId = this.requireNonBlank(tenantId);
        this.tenantName = this.requireNonBlank(tenantName);
        this.credentials = Objects.requireNonNull(credentials);
        this.kind = Objects.requireNonNull(kind);
        this.scimAuthMethod = scimAuthMethod;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ScimProviderKind getKind() {
        return this.kind;
    }

    public ScimAuthMethod getScimAuthMethod() {
        return this.scimAuthMethod;
    }

    private String requireNonBlank(String value) {
        if (StringUtils.isBlank(value)) {
            throw new IllegalArgumentException("Non-blank value required");
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimTenantConfig that = (ScimTenantConfig)o;
        return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.tenantName, that.tenantName) && Objects.equals(this.credentials, that.credentials) && this.kind == that.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tenantId, this.tenantName, this.credentials, this.kind});
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("tenantId", this.tenantId);
        json.put("tenantName", this.tenantName);
        json.put("applicationSecret", "< REDACTED >");
        json.put("ScimProviderKind", this.kind.getName());
        return json;
    }
}

