/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.util;

import com.atlassian.json.jsonorg.JSONObject;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public final class SessionIdentificationHelper {
    private static final String IDP_ID = "idpId";
    private static final String NAME_ID = "nameId";
    private static final String NAME_ID_FORMAT = "nameIdFormat";
    private static final String SESSION_INDEX = "sessionIndex";

    public static SAMLSessionIdentification fromJson(String jsonString) {
        JSONObject json = new JSONObject(jsonString);
        String idpId = json.getString(IDP_ID);
        String nameId = json.getString(NAME_ID);
        String nameIdFormat = json.isNull(NAME_ID_FORMAT) ? null : json.getString(NAME_ID_FORMAT);
        String sessionIndex = json.isNull(SESSION_INDEX) ? null : json.getString(SESSION_INDEX);
        return new SAMLSessionIdentification(idpId, nameId, nameIdFormat, sessionIndex);
    }

    public static String toJson(SAMLSessionIdentification sessionIdentification) {
        return new JSONObject(sessionIdentification).toString();
    }
}

