/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.util;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.util.concurrent.NotNull;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.BuildInfoUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptInjector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final String contextPath;
    private final String version;

    public ScriptInjector(TemplateRenderer templateRenderer, KerbConfManager kerbConfManager, String contextPath) {
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = kerbConfManager;
        this.contextPath = contextPath;
        this.version = BuildInfoUtils.getInstance().getVersion();
    }

    @NotNull
    public StringWriter prepareInjectScript(boolean isTraditionalLoginDisabled, boolean enableFederatedSSO, boolean manualLogin, int samlRedirectDelay, String emailFromHeader) throws IOException {
        StringWriter inject = new StringWriter();
        this.log.debug("Writing js and css enhancment. isTraditionalLoginDisabled: " + isTraditionalLoginDisabled + " enableFederatedSSO: " + enableFederatedSSO + " manualLogin: " + manualLogin + " samlRedirectDelay: " + samlRedirectDelay);
        if (isTraditionalLoginDisabled) {
            new PluginKey();
            this.appendScript(inject, PluginKey.getPluginKey() + ":disable-login/disable-login-" + this.version + ".js");
            new PluginKey();
            this.appendLink(inject, PluginKey.getPluginKey() + ":disable-login/disable-login-" + this.version + ".css");
        }
        if (enableFederatedSSO) {
            new PluginKey();
            this.appendScript(inject, PluginKey.getPluginKey() + ":saml-login/saml-login-" + this.version + ".js");
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
            model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
            model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
            model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
            model.put("shouldLoginManually", manualLogin);
            model.put("redirectProgressDelay", samlRedirectDelay + "s");
            if (StringUtils.isNotBlank((String)emailFromHeader)) {
                model.put("emailFromHeader", emailFromHeader);
                this.templateRenderer.render("templates/atlaskerb/jsd-signup-email-signup.vm", model, (Writer)inject);
            }
            this.templateRenderer.render("templates/atlaskerb/saml-login.vm", model, (Writer)inject);
        }
        return inject;
    }

    private void appendScript(StringWriter inject, String file) {
        String src = this.contextPath + "/download/resources/" + file;
        inject.append("<script src=\"" + src + "\"></script>");
    }

    private void appendLink(StringWriter inject, String file) {
        String src = this.contextPath + "/download/resources/" + file;
        inject.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"" + src + "\">");
    }
}

