/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.logout;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class SingleLogoutFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SingleLogoutFilter.class);
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SingleLogoutAppHelper logoutAppHelper;
    private String[] products;

    @Inject
    public SingleLogoutFilter(IdpConfManager idpConfManager, HostAppFactory hostAppFactory, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory) {
        this.idpConfManager = idpConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this.isProductMatch() || req.getParameter("nosaml") != null) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String qs = req.getQueryString();
        if (StringUtils.contains((CharSequence)req.getRequestURI(), "/servicedesk/") && (!StringUtils.contains((CharSequence)qs, "logout=true") || StringUtils.contains((CharSequence)qs, "slo=finished"))) {
            chain.doFilter(request, response);
            return;
        }
        log.debug("Intercepting logout request: {}", (Object)req.getRequestURI());
        String idpConfigId = this.logoutAppHelper.getIdFromCookieAndSetSessionId(req, res);
        if (!StringUtils.isBlank(idpConfigId)) {
            Cookie cookie = new Cookie("krb_logout_uri", req.getRequestURI());
            cookie.setPath(req.getContextPath() + "/");
            cookie.setComment("HttpOnly");
            res.addCookie(cookie);
        } else {
            Try<IdpConfiguration> maybeIdpConfigId = Try.of(() -> req.getSession(false)).flatMap(s -> Option.of(s.getAttribute("sessionIdentification")).toTry()).map(Object::toString).filter(StringUtils::isNotBlank).map(SessionIdentificationHelper::fromJson).map(SAMLSessionIdentification::getIdpId).orElse(Try.of(() -> req.getSession(false)).filterTry(Objects::nonNull).mapTry(s -> s.getAttribute("ksso.oidc.idp.id")).filterTry(Objects::nonNull).mapTry(Object::toString)).onFailure(_e -> log.debug("Unable to identify a 3rd party as an authority for this session.")).mapTry(this.idpConfManager::getIdentityProviderById).filterTry(IdpConfiguration::isSingleLogoutEnabled);
            if (maybeIdpConfigId.isEmpty()) {
                chain.doFilter(request, response);
                return;
            }
            idpConfigId = maybeIdpConfigId.get().getId();
        }
        this.logoutAppHelper.initiateLogout(req, res, idpConfigId);
    }

    public void destroy() {
    }
}

