/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.TestKerberosAction;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogin;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCStateCache;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@Scanned
public class UserTestServlet
extends HttpServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final OIDCStateCache oidcStateCache;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final ErrorPageRenderer errorPageRenderer;

    @Inject
    public UserTestServlet(@ComponentImport TemplateRenderer renderer, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport UserManager userManager, OIDCStateCache oidcStateCache, IdpConfManager idpConfManager, HostAppFactory hostAppFactory, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper, ErrorPageRenderer errorPageRenderer) {
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.oidcStateCache = oidcStateCache;
        this.idpConfManager = idpConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.oidcProcedureFactoryWrapper = oidcProcedureFactoryWrapper;
        this.errorPageRenderer = errorPageRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI = req.getRequestURI();
        String id = requestURI.substring(requestURI.lastIndexOf("/sp/") + "/sp/".length(), requestURI.lastIndexOf("/"));
        IdpConfiguration idpConfiguration = this.idpConfManager.getIdentityProviderById(id);
        IdpConfiguration.SSOProtocol ssoProtocol = idpConfiguration.getProtocol();
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        resp.setContentType("text/html");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("added", req.getParameter("added") != null);
        model.put("idp", idpConfiguration);
        model.put("ssoProtocol", (Object)ssoProtocol);
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":atlaskerb");
        model.put("runtest", req.getParameter("runtest") != null);
        model.put("added", req.getParameter("added") != null);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("isSystemAdmin", this.isSystemAdmin(req));
        model.put("ack", req.getParameter("ack") != null);
        model.put("testID", req.getParameter("testID"));
        boolean smtpSupported = this.hostApp.isSMTPSupported();
        model.put("mailSupported", smtpSupported);
        if (smtpSupported) {
            model.put("mailServerDefined", this.hostApp.isSMTPEnabled());
        }
        model.put("mailSettingsAction", this.idpConfManager.getServiceProviderTestURL(req, id));
        model.put("krb_token", req.getSession().getAttribute("krb_csrf_token"));
        model.put("testResultsURL", this.idpConfManager.getServiceProviderTestURL(req, id));
        model.put("shareURL", this.idpConfManager.getServiceProviderNonAdminTestURL(req, id));
        if (idpConfiguration.isOIDC()) {
            String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
            boolean prepareTestUrl = true;
            OIDCIdpConfiguration oidcIdpConfiguration = (OIDCIdpConfiguration)idpConfiguration;
            model.put("testURL", InitiateOidcLogin.run(req, resp, oidcIdpConfiguration, this.idpConfManager, callbackUrl, null, null, prepareTestUrl, this.oidcStateCache, null, this.oidcProcedureFactoryWrapper, this.errorPageRenderer, this.userManager));
        } else {
            model.put("testURL", "login?test");
        }
        model.put("is_logged_in", this.hostApp.isLoggedIn(req));
        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
        this.renderer.render("templates/idp-usertest.vm", model, (Writer)resp.getWriter());
    }

    private boolean isSystemAdmin(HttpServletRequest request) {
        return HttpUrlUtils.isSystemAdmin(this.userManager, request);
    }
}

