/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class SSOLoginScreenServlet
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final IdpConfManager idpConfManager;

    @Inject
    public SSOLoginScreenServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "SAML");
        model.put("menuItem", "loginScreen");
        model.put("samlEnabled", this.idpConfManager.isSamlEnabled());
        this.templateRenderer.render("templates/saml/saml-login-screen.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("disable") != null) {
            this.idpConfManager.setSamlEnabled(false);
        }
        if (req.getParameter("enable") != null) {
            this.idpConfManager.setSamlEnabled(true);
        }
        resp.sendRedirect("providers");
    }
}

