/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class SSOLoginHookContextProvider
implements ContextProvider {
    private final HostApp hostApp;
    private final HttpContext httpContext;
    private final IdpConfManager idpConfigManager;
    private final KerbConfManager kerbConfManager;

    @Inject
    public SSOLoginHookContextProvider(@ComponentImport HttpContext httpContext, HostAppFactory hostApp, IdpConfManager idpConfigManager, KerbConfManager kerbConfManager) {
        this.hostApp = hostApp.getInstance();
        this.idpConfigManager = idpConfigManager;
        this.httpContext = httpContext;
        this.kerbConfManager = kerbConfManager;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        boolean manual = this.hostApp.shouldLoginManually(this.httpContext.getRequest(), this.httpContext.getResponse());
        model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
        model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
        model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
        model.put("shouldLoginManually", manual);
        model.put("redirectProgressDelay", this.idpConfigManager.getRedirectProgressDelay() + "s");
        return model;
    }
}

