/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import io.vavr.control.Option;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public class SAMLIdpConfiguration
extends IdpConfiguration {
    public static final String DEFAULT_AUTHN_CONTEXT_CLASS_REF = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
    private final String idpURL;
    private final List<byte[]> signingCerts;
    private final boolean encryptedAssertionsRequired;
    private final boolean usePostBinding;
    private final String metadataURL;
    private final String singleLogoutServiceURL;
    private final String tlsFingerprint;
    private final RequestedAuthnContextPolicy requestedAuthnContextPolicy;
    private final RequestedAuthnContextComparison requestedAuthnContextComparison;
    private final String authnContextClassRef;
    private final IssuerPolicy issuerPolicy;
    private final String issuer;
    private final IdpConfiguration.AllowCreate allowCreate;
    private final IdpConfiguration.NameIdFormat nameIdFormat;
    private final String customNameIdFormat;
    private final SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy;
    private final boolean autoRefreshMetadataEnabled;

    public SAMLIdpConfiguration(IdpConfiguration.AllowCreate allowCreate, Set<String> defaultGroups, Map<String, String> defaultGroupsRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customUsernameAttributeName, boolean enabled, String id, Optional<Long> jitDirectory, IdpConfiguration.Kind kind, LinkedHashSet<String> knownDomains, boolean knownAutoRedirect, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, boolean managedGroupsRequiredForJITCreation, Set<Long> matchedUserDirectoryIds, String name, String notificationEmails, Set<String> redirectGroups, IdpConfiguration.RedirectPolicy redirectPolicy, List<Pair<String, String>> userTransformationRegexes, boolean singleLogoutEnabled, IdpConfiguration.UserActivatePolicy userActivatePolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UsernamePolicy usernamePolicy, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserUpdatePolicy userUpdatePolicy, boolean visible, boolean hostedDomain, String selectedUsernameAttributeInfo, Set<String> idpGroupsAttribute, boolean sendLoginHint, boolean authenticatedAnonymousBrowsingEnabled, String authnContextClassRef, String customNameIdFormat, boolean encryptedAssertionsRequired, boolean usePostBinding, String idpURL, String issuer, IssuerPolicy issuerPolicy, String metadataURL, IdpConfiguration.NameIdFormat nameIdFormat, SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy, List<byte[]> signingCerts, String singleLogoutServiceURL, String singleLogoutReturnURL, String tlsFingerprint, RequestedAuthnContextComparison requestedAuthnContextComparison, RequestedAuthnContextPolicy requestedAuthnContextPolicy, boolean autoRefreshMetadataEnabled) {
        super(defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, knownAutoRedirect, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, managedGroupsRequiredForJITCreation, matchedUserDirectoryIds, name, notificationEmails, redirectGroups, redirectPolicy, userTransformationRegexes, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdatePolicy, visible, hostedDomain, selectedUsernameAttributeInfo, idpGroupsAttribute, singleLogoutReturnURL, sendLoginHint, authenticatedAnonymousBrowsingEnabled);
        this.idpURL = idpURL;
        this.signingCerts = signingCerts;
        this.encryptedAssertionsRequired = encryptedAssertionsRequired;
        this.usePostBinding = usePostBinding;
        this.metadataURL = metadataURL;
        this.singleLogoutServiceURL = singleLogoutServiceURL;
        this.sessionIdentificationValidationPolicy = sessionIdentificationValidationPolicy;
        this.tlsFingerprint = tlsFingerprint;
        this.requestedAuthnContextPolicy = requestedAuthnContextPolicy;
        this.requestedAuthnContextComparison = requestedAuthnContextComparison;
        this.authnContextClassRef = authnContextClassRef;
        this.issuerPolicy = issuerPolicy;
        this.issuer = issuer;
        this.nameIdFormat = nameIdFormat;
        this.customNameIdFormat = customNameIdFormat;
        this.allowCreate = allowCreate;
        this.autoRefreshMetadataEnabled = autoRefreshMetadataEnabled;
    }

    @Override
    public IdpConfiguration.SSOProtocol getProtocol() {
        return IdpConfiguration.SSOProtocol.SAML;
    }

    public IssuerPolicy getIssuerPolicy() {
        return this.issuerPolicy;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIdpURL() {
        return this.idpURL;
    }

    public String getMetadataURL() {
        return this.metadataURL;
    }

    public String getSingleLogoutServiceURL() {
        return this.singleLogoutServiceURL;
    }

    public String getTlsFingerprint() {
        return this.tlsFingerprint;
    }

    public boolean supportForceAuthn() {
        return this.getIdpURL() != null && this.getIdpURL().contains("/adfs/ls");
    }

    public List<byte[]> getSigningCerts() {
        return this.signingCerts;
    }

    public RequestedAuthnContextPolicy getRequestedAuthnContextPolicy() {
        return this.requestedAuthnContextPolicy;
    }

    public RequestedAuthnContextComparison getRequestedAuthnContextComparison() {
        return this.requestedAuthnContextComparison;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public IdpConfiguration.NameIdFormat getNameIdFormat() {
        return this.nameIdFormat;
    }

    public String getCustomNameIdFormat() {
        return this.customNameIdFormat;
    }

    public boolean isEncryptedAssertionsRequired() {
        return this.encryptedAssertionsRequired;
    }

    public boolean isUsePostBinding() {
        return this.usePostBinding;
    }

    public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy() {
        return this.sessionIdentificationValidationPolicy;
    }

    public IdpConfiguration.AllowCreate getAllowCreate() {
        return this.allowCreate;
    }

    public boolean isAutoRefreshMetadataEnabled() {
        return this.autoRefreshMetadataEnabled;
    }

    @Override
    public boolean isOIDC() {
        return false;
    }

    @Override
    public boolean isSAML() {
        return true;
    }

    @Override
    public JSONObject asJson() {
        CertTool certTool = new CertTool();
        JSONObject json = super.asJson();
        json.put("idpURL", this.getIdpURL());
        json.put("signingCerts", new JSONArray(io.vavr.collection.List.ofAll(this.getSigningCerts()).map(bytes -> {
            X509Certificate cert = certTool.parse((byte[])bytes);
            JSONObject certJson = new JSONObject();
            certJson.put("subjectDn", cert.getSubjectDN().getName());
            certJson.put("notBefore", cert.getNotBefore().toString());
            certJson.put("notAfter", cert.getNotAfter().toString());
            certJson.put("sigAlgName", cert.getSigAlgName());
            certJson.put("keySize", String.valueOf(certTool.getKeySize(cert)));
            certJson.put("fingerPrint", certTool.fingerPrint((byte[])bytes));
            return certJson;
        }).asJava()));
        json.put("encryptedAssertionsRequired", this.isEncryptedAssertionsRequired());
        json.put("usePostBinding", this.isUsePostBinding());
        json.put("metadataURL", this.getMetadataURL());
        json.put("singleLogoutServiceURL", this.getSingleLogoutServiceURL());
        json.put("tlsFingerprint", this.getTlsFingerprint());
        json.put("requestedAuthnContextPolicy", this.getRequestedAuthnContextPolicy().name());
        json.put("requestedAuthnContextComparison", this.getRequestedAuthnContextComparison().name());
        json.put("authnContextClassRef", this.getAuthnContextClassRef());
        json.put("issuerPolicy", this.getIssuerPolicy().name());
        json.put("issuer", this.getIssuer());
        json.put("allowCreate", this.getAllowCreate().name());
        json.put("nameIdFormat", this.getNameIdFormat().name());
        json.put("customNameIdFormat", this.getCustomNameIdFormat());
        json.put("sessionIdentificationValidationPolicy", Option.of(this.getSessionIdentificationValidationPolicy()).getOrElse(SAMLSessionIdentification.ValidationPolicy.getDefault()).name());
        return json;
    }

    public static enum IssuerPolicy {
        DEFAULT,
        CUSTOM;

    }

    public static enum RequestedAuthnContextComparison {
        EXACT,
        MINIMUM,
        MAXIMUM,
        BETTER;

    }

    public static enum RequestedAuthnContextPolicy {
        DO_NOT_SEND,
        CUSTOM;

    }
}

