/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;

@Scanned
public class IdpsConfigServlet
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final UserLookupService userLookupService;

    @Inject
    public IdpsConfigServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        this.idpConfManager.readState();
        model.put("menuItem", "providerList");
        model.put("topMenu", "SAML");
        model.put("providerKinds", IdpConfiguration.Kind.values());
        model.put("providers", this.idpConfManager.getIdentityProviders());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("idpConfManager", this.idpConfManager);
        model.put("samlEnabled", this.idpConfManager.isSamlEnabled());
        model.put("dateUtils", new DateUtils());
        model.put("dateTool", new DateTool());
        model.put("samlUtils", new SamlUtils(this.idpConfManager, req));
        model.put("drafts", this.idpConfManager.getProviderDrafts());
        if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
            model.put("license", this.kerbConfManager.getLicenseManager().getLicense().get());
        }
        List<IdpConfiguration.RedirectPolicy> exclusiveRedirectPolicies = Arrays.asList(IdpConfiguration.RedirectPolicy.HARD, IdpConfiguration.RedirectPolicy.ALL);
        Collection idpConfigurations = this.idpConfManager.getIdentityProviders().stream().filter(config -> config.isEnabled()).collect(Collectors.toList());
        List exclusiveConfigurations = idpConfigurations.stream().filter(config -> exclusiveRedirectPolicies.contains((Object)config.getRedirectPolicy())).collect(Collectors.toList());
        List activeNonExclusiveConfigurations = idpConfigurations.stream().filter(config -> {
            if (config.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.NONE) {
                return false;
            }
            return !exclusiveConfigurations.contains(config);
        }).collect(Collectors.toList());
        if (exclusiveConfigurations.size() > 0) {
            model.put("exclusiveConfigurations", exclusiveConfigurations);
            if (exclusiveConfigurations.size() > 1) {
                model.put("warningMultipleExclusiveConfigurations", true);
            }
            if (activeNonExclusiveConfigurations.size() > 0) {
                model.put("warningUnusedActiveConfigurations", true);
                model.put("activeNonExclusiveConfigurations", activeNonExclusiveConfigurations);
            }
        }
        model.put("directoryById", this.directoryById(this.userLookupService.getActiveUserDirectories()));
        this.templateRenderer.render("templates/idps-main.vm", model, (Writer)resp.getWriter());
    }

    private Map<Long, Directory> directoryById(List<Directory> activeUserDirectories) {
        HashMap<Long, Directory> directories = new HashMap<Long, Directory>();
        for (Directory directory : activeUserDirectories) {
            directories.put(directory.getId(), directory);
        }
        return directories;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String toggleEnabled;
        String deleteDraftId;
        String removeIdp = req.getParameter("removeIdp");
        if (removeIdp != null) {
            this.idpConfManager.removeIdentityProvider(removeIdp);
        }
        if ((deleteDraftId = req.getParameter("deleteDraftId")) != null) {
            this.idpConfManager.deleteProviderDraft(deleteDraftId);
        }
        if ((toggleEnabled = req.getParameter("toggle-enabled-idp")) != null) {
            IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(toggleEnabled);
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(existing);
            builder.setEnabled(!existing.isEnabled());
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        if (this.idpConfManager.getIdentityProviders().isEmpty() && this.idpConfManager.getProviderDrafts().isEmpty()) {
            resp.sendRedirect("dashboard");
        } else {
            resp.sendRedirect("providers");
        }
    }

    public static class SamlUtils {
        private final IdpConfManager idpConfManager;
        private final HttpServletRequest req;

        public SamlUtils(IdpConfManager idpConfManager, HttpServletRequest req) {
            this.idpConfManager = idpConfManager;
            this.req = req;
        }

        public String getLoginUrl(SAMLIdpConfiguration configuration) {
            return this.idpConfManager.getServiceProviderLoginURL(this.req, configuration.getId());
        }

        public String getTestUrl(SAMLIdpConfiguration configuration) {
            return this.idpConfManager.getServiceProviderTestURL(this.req, configuration.getId());
        }

        public String knownDomainList(Set<String> domains) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator2 = domains.iterator();
            while (iterator2.hasNext()) {
                String domain = iterator2.next();
                sb.append("@").append(domain);
                if (!iterator2.hasNext()) continue;
                sb.append(" or ");
            }
            return sb.toString();
        }
    }

    public static class DateUtils {
        public long daysUntil(Date date) {
            long diff = date.getTime() - System.currentTimeMillis();
            long days = diff / 86400000L;
            return days;
        }
    }
}

