/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;

@Scanned
public class IdpSamlSettingsServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;

    @Inject
    public IdpSamlSettingsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = this.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "samlSettings");
        model.put("idp", configuration);
        model.put("productName", this.applicationProperties.getDisplayName());
        model.put("comparisons", SAMLIdpConfiguration.RequestedAuthnContextComparison.values());
        model.put("defaultIssuer", this.idpConfManager.getServiceProviderLoginURL(req, id));
        this.getTemplateRenderer().render("templates/saml/saml-idp-saml-settings.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = this.getId(req);
        IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(id);
        SAMLIdpConfiguration.IssuerPolicy issuerPolicy = SAMLIdpConfiguration.IssuerPolicy.valueOf(req.getParameter("issuerPolicy"));
        String issuer = req.getParameter("issuer").trim();
        IdpConfiguration.AllowCreate allowCreate = IdpConfiguration.AllowCreate.valueOf(req.getParameter("allowCreate"));
        IdpConfiguration.NameIdFormat nameIdFormat = IdpConfiguration.NameIdFormat.valueOf(req.getParameter("nameIdFormat"));
        String customNameIdFormat = req.getParameter("customNameIdFormat").trim();
        SAMLIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy = SAMLIdpConfiguration.RequestedAuthnContextPolicy.valueOf(req.getParameter("requestedAuthnContext"));
        SAMLIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison = SAMLIdpConfiguration.RequestedAuthnContextComparison.valueOf(req.getParameter("requestedAuthnContextComparison").toUpperCase());
        String authnContextClassRef = req.getParameter("authnContextClassRef").trim();
        boolean encryptedAssertionsRequired = StringUtils.equalsIgnoreCase("on", req.getParameter("encryptedAssertionsRequired"));
        boolean usePostBinding = StringUtils.equalsIgnoreCase("on", req.getParameter("usePostBinding"));
        IdpConfiguration updated = this.idpConfManager.getIdentityProviderById(id).fold(oidc -> {
            throw new RuntimeException("OIDC config not expected: " + id);
        }, saml -> (SAMLIdpConfiguration)IdpConfigurationBuilder.of(saml).setAllowCreate(allowCreate).setAuthnCtxClassRef(authnContextClassRef).setCustomNameIdFormat(customNameIdFormat).setEncryptedAssertionsRequired(encryptedAssertionsRequired).setUsePostBinding(usePostBinding).setIssuer(issuer).setIssuerPolicy(issuerPolicy).setNameIdFormat(nameIdFormat).setRequestedAuthnContextComparison(requestedAuthnContextComparison).setRequestedAuthnContextPolicy(requestedAuthnContextPolicy).build());
        this.idpConfManager.updateIdpConfiguration(updated);
        resp.sendRedirect("samlsettings");
    }

    private boolean isEmpty(String nameParam) {
        return nameParam == null || nameParam.trim().isEmpty();
    }
}

